/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.resource.CoverageBandsConfigurationPanel;
import org.junit.Assert;
import org.junit.Test;

public class CoverageBandsConfigurationPanelTest
extends GeoServerWicketTestSupport {
    public static QName HYPER = new QName(SystemTestData.WCS_URI, "Hyper", SystemTestData.WCS_PREFIX);

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addDefaultRasterLayer(SystemTestData.TASMANIA_BM, this.getCatalog());
        testData.addRasterLayer(HYPER, "hyper.tiff", "tiff", null, SystemTestData.class, this.getCatalog());
    }

    @Test
    public void testBands() throws Exception {
        CoverageInfo coverage = this.getCatalog().getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_BM));
        Model model = new Model((Serializable)coverage);
        FormTestPage page = new FormTestPage(id -> new CoverageBandsConfigurationPanel(id, (IModel)model));
        tester.startPage((Page)page);
        MarkupContainer container = (MarkupContainer)tester.getComponentFromLastRenderedPage("form:panel:bands:listContainer:items");
        Assert.assertEquals((long)3L, (long)container.size());
    }

    @Test
    public void testHyperspectral() throws Exception {
        CoverageInfo coverage = this.getCatalog().getCoverageByName(this.getLayerId(HYPER));
        Model model = new Model((Serializable)coverage);
        FormTestPage page = new FormTestPage(id -> new CoverageBandsConfigurationPanel(id, (IModel)model));
        tester.startPage((Page)page);
        MarkupContainer container = (MarkupContainer)tester.getComponentFromLastRenderedPage("form:panel:bands:listContainer:items");
        Assert.assertEquals((long)326L, (long)container.size());
    }
}

