/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.WMSStoreInfoImpl;
import org.geoserver.catalog.impl.WMTSStoreInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.util.GeoServerDefaultLocale;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.resource.BasicResourceConfig;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.ColorPickerPanel;
import org.geoserver.web.data.store.panel.DropDownChoiceParamPanel;
import org.geoserver.web.data.store.panel.ParamPanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.util.MapModel;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.FactoryException;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.jdbc.VirtualTable;
import org.geotools.referencing.CRS;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.io.WKTReader;
import org.springframework.security.core.Authentication;

public class ResourceConfigurationPageTest
extends GeoServerWicketTestSupport {
    protected static QName TIMERANGES = new QName(MockData.SF_URI, "timeranges", MockData.SF_PREFIX);
    protected static QName LINES = new QName(MockData.SF_URI, "null_srid_line", MockData.SF_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(TIMERANGES, "timeranges.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addVectorLayer(LINES, Collections.emptyMap(), "null_srid_line.properties", ResourceConfigurationPageTest.class, this.getCatalog());
    }

    @Before
    public void resetAttributeRenames() throws IOException {
        this.revertLayer(MockData.GENERICENTITY);
    }

    @Test
    public void testBasic() {
        LayerInfo layer = this.getGeoServerApplication().getCatalog().getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS));
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        tester.assertLabel("publishedinfoname", layer.getResource().prefixedName());
        tester.assertComponent("publishedinfo:tabs:panel:theList:0:content", BasicResourceConfig.class);
    }

    @Test
    public void testResourceConfigurationPageInfoLabels() {
        LayerInfo layer = this.getGeoServerApplication().getCatalog().getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS));
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        String storeNamePath = "publishedinfo:tabs:panel:theList:0:content:storeName";
        Assert.assertNotNull((Object)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:storeName").getMarkup());
        tester.assertLabel("publishedinfo:tabs:panel:theList:0:content:storeName", layer.getResource().getStore().getName());
        String nativeNamePath = "publishedinfo:tabs:panel:theList:0:content:nativeName";
        Assert.assertNotNull((Object)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:nativeName").getMarkup());
        tester.assertLabel("publishedinfo:tabs:panel:theList:0:content:nativeName", layer.getResource().getNativeName());
    }

    @Test
    public void testUpdateResource() {
        LayerInfo layer = this.getGeoServerApplication().getCatalog().getLayerByName(this.getLayerId(MockData.GEOMETRYLESS));
        this.login();
        final ResourceConfigurationPage page = new ResourceConfigurationPage(layer, false);
        tester.startPage((Page)page);
        tester.assertContainsNot("the_geom");
        final FeatureTypeInfo info = (FeatureTypeInfo)this.getCatalog().getResourceByName(MockData.BRIDGES.getLocalPart(), FeatureTypeInfo.class);
        page.add(new Behavior[]{new AjaxEventBehavior("ondblclick"){

            public void onEvent(AjaxRequestTarget target) {
                page.updateResource((ResourceInfo)info, target);
            }
        }});
        tester.executeAjaxEvent((Component)page, "ondblclick");
        tester.assertContains("the_geom");
    }

    @Test
    public void testSerializedModel() throws Exception {
        ResourceConfigurationPage page2;
        byte[] serialized;
        CatalogFactory fac = this.getGeoServerApplication().getCatalog().getFactory();
        FeatureTypeInfo fti = fac.createFeatureType();
        fti.setName("mylayer");
        fti.setStore((StoreInfo)this.getGeoServerApplication().getCatalog().getDataStoreByName(MockData.POLYGONS.getPrefix()));
        LayerInfo layer = fac.createLayer();
        layer.setResource((ResourceInfo)fti);
        this.login();
        ResourceConfigurationPage page = new ResourceConfigurationPage(layer, true);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                oos.writeObject(page);
            }
            serialized = os.toByteArray();
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(serialized);
             ObjectInputStream ois = new ObjectInputStream(is);){
            page2 = (ResourceConfigurationPage)ois.readObject();
        }
        Assert.assertTrue((boolean)(page2.getPublishedInfo() instanceof LayerInfo));
        Assert.assertEquals((Object)layer.prefixedName(), (Object)((LayerInfo)page2.getPublishedInfo()).prefixedName());
        Assert.assertNotNull((Object)((LayerInfo)page2.getPublishedInfo()).getResource().getCatalog());
    }

    @Test
    public void testComputeLatLon() throws Exception {
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setStore(catalog.getStoreByName(MockData.POLYGONS.getPrefix(), DataStoreInfo.class));
        FeatureTypeInfo ft = cb.buildFeatureType((Name)new NameImpl(MockData.POLYGONS));
        LayerInfo layer = cb.buildLayer(ft);
        this.login();
        ResourceConfigurationPage page = new ResourceConfigurationPage(layer, true);
        tester.startPage((Page)page);
        this.print((Component)tester.getLastRenderedPage(), true, true, true);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:referencingForm:computeLatLon", "click");
        this.print((Component)tester.getLastRenderedPage(), true, true, true);
        tester.assertNoErrorMessage();
        Component llbox = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:latLonBoundingBox");
        ReferencedEnvelope re = (ReferencedEnvelope)llbox.getDefaultModelObject();
        Assert.assertEquals((double)-93.0, (double)re.getMinX(), (double)0.1);
        Assert.assertEquals((double)4.5, (double)re.getMinY(), (double)0.1);
        Assert.assertEquals((double)-93.0, (double)re.getMaxX(), (double)0.1);
        Assert.assertEquals((double)4.5, (double)re.getMaxY(), (double)0.1);
    }

    @Test
    public void testParametersUI() throws Exception {
        LayerInfo layer = this.getGeoServerApplication().getCatalog().getLayerByName(this.getLayerId(TIMERANGES));
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        ListView parametersList = (ListView)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:1:content:parameters");
        parametersList.visitChildren(ParamPanel.class, (c, v) -> {
            MapModel mapModel = (MapModel)c.getDefaultModel();
            String parameterKey = mapModel.getExpression();
            if (AbstractGridFormat.USE_JAI_IMAGEREAD.getName().getCode().equals(parameterKey) || ImageMosaicFormat.ACCURATE_RESOLUTION.getName().getCode().equals(parameterKey) || ImageMosaicFormat.ALLOW_MULTITHREADING.getName().getCode().equals(parameterKey) || AbstractGridFormat.RESCALE_PIXELS.getName().getCode().equals(parameterKey)) {
                MatcherAssert.assertThat((String)parameterKey, (Object)c, (Matcher)CoreMatchers.instanceOf(CheckBoxParamPanel.class));
            } else if (ImageMosaicFormat.EXCESS_GRANULE_REMOVAL.getName().getCode().equals(parameterKey) || AbstractGridFormat.FOOTPRINT_BEHAVIOR.getName().getCode().equals(parameterKey) || ImageMosaicFormat.MERGE_BEHAVIOR.getName().getCode().equals(parameterKey) || AbstractGridFormat.OVERVIEW_POLICY.getName().getCode().equals(parameterKey)) {
                MatcherAssert.assertThat((String)parameterKey, (Object)c, (Matcher)CoreMatchers.instanceOf(DropDownChoiceParamPanel.class));
            } else if (AbstractGridFormat.BACKGROUND_COLOR.getName().getCode().equals(parameterKey) || ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.getName().getCode().equals(parameterKey) || AbstractGridFormat.INPUT_TRANSPARENT_COLOR.getName().getCode().equals(parameterKey)) {
                MatcherAssert.assertThat((String)parameterKey, (Object)c, (Matcher)CoreMatchers.instanceOf(ColorPickerPanel.class));
            } else {
                MatcherAssert.assertThat((String)parameterKey, (Object)c, (Matcher)CoreMatchers.instanceOf(TextParamPanel.class));
            }
        });
        tester.assertComponent("publishedinfo:tabs:panel:theList:1:content:parameters:0:parameterPanel", CheckBoxParamPanel.class);
    }

    @Test
    public void testMissingParameters() {
        CoverageInfo coverage = this.getCatalog().getCoverageByName(this.getLayerId(TIMERANGES));
        String bandCode = ImageMosaicFormat.BANDS.getName().getCode();
        coverage.getParameters().remove(bandCode);
        this.getCatalog().save((ResourceInfo)coverage);
        LayerInfo layer = this.getCatalog().getLayerByName(this.getLayerId(TIMERANGES));
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        ListView parametersList = (ListView)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:1:content:parameters");
        AtomicBoolean editorFound = new AtomicBoolean(false);
        parametersList.visitChildren(ParamPanel.class, (c, v) -> {
            MapModel mapModel = (MapModel)c.getDefaultModel();
            String parameterKey = mapModel.getExpression();
            if (bandCode.equals(parameterKey)) {
                editorFound.set(true);
            }
        });
        Assert.assertTrue((String)"Bands parameter not found", (boolean)editorFound.get());
    }

    @Test
    public void testSaveEnumsAsString() {
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(TIMERANGES));
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        ListView parametersList = (ListView)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:1:content:parameters");
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        parametersList.visitChildren(ParamPanel.class, (c, v) -> {
            MapModel mapModel = (MapModel)c.getDefaultModel();
            String parameterKey = mapModel.getExpression();
            if (AbstractGridFormat.OVERVIEW_POLICY.getName().getCode().equals(parameterKey)) {
                ref.set(c.getPageRelativePath().substring("publishedInfo".length() + 1));
            }
        });
        FormTester ft = tester.newFormTester("publishedinfo");
        ft.select(ref.get() + ":border:border_body:paramValue", 2);
        tester.debugComponentTrees();
        ft.submit("save");
        tester.assertNoErrorMessage();
        CoverageInfo ci = (CoverageInfo)catalog.getResourceByName(TIMERANGES.getPrefix(), TIMERANGES.getLocalPart(), CoverageInfo.class);
        Map parameters = ci.getParameters();
        Assert.assertEquals((Object)"NEAREST", parameters.get(AbstractGridFormat.OVERVIEW_POLICY.getName().toString()));
    }

    @Test
    public void testApply() {
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        LayerInfo layer = catalog.getLayerByName(layerId);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        FormTester ft = tester.newFormTester("publishedinfo");
        String newTitle = "A test title";
        ft.setValue("tabs:panel:theList:0:content:titleAndAbstract:title", newTitle);
        ft.submit("apply");
        tester.executeAjaxEvent("publishedinfo:apply", "submit");
        tester.assertNoErrorMessage();
        MatcherAssert.assertThat((Object)tester.getLastRenderedPage(), (Matcher)Matchers.instanceOf(ResourceConfigurationPage.class));
        Assert.assertEquals((Object)newTitle, (Object)this.getCatalog().getLayerByName(layerId).getTitle());
    }

    @Test
    public void testWFSDataStoreResource() throws IOException {
        String baseURL = "http://mock.test.geoserver.org";
        MockHttpClient client = new MockHttpClient();
        URL descURL = new URL(baseURL + "/wfs?REQUEST=DescribeFeatureType&VERSION=1.1.0&SERVICE=WFS");
        client.expectGet(descURL, (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("/desc_110.xml"), "text/xml", new String[0]));
        URL descFeatureURL = new URL(baseURL + "/wfs?NAMESPACE=xmlns%28topp%3Dhttp%3A%2F%2Fwww.topp.com%29&TYPENAME=topp%3Aroads22&REQUEST=DescribeFeatureType&VERSION=1.1.0&SERVICE=WFS");
        client.expectGet(descFeatureURL, (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("/desc_feature.xml"), "text/xml", new String[0]));
        TestHttpClientProvider.bind((HTTPClient)client, (URL)descURL);
        TestHttpClientProvider.bind((HTTPClient)client, (URL)descFeatureURL);
        URL url = ((Object)((Object)this)).getClass().getResource("/wfs_cap_110.xml");
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        DataStoreInfo storeInfo = cb.buildDataStore("MockWFSDataStore");
        ((DataStoreInfoImpl)storeInfo).setId("1");
        storeInfo.setType("Web Feature Server (NG)");
        storeInfo.getConnectionParameters().put(WFSDataStoreFactory.URL.key, url);
        storeInfo.getConnectionParameters().put("usedefaultsrs", Boolean.FALSE);
        storeInfo.getConnectionParameters().put(WFSDataStoreFactory.PROTOCOL.key, Boolean.FALSE);
        storeInfo.getConnectionParameters().put("TESTING", Boolean.TRUE);
        this.getCatalog().add((StoreInfo)storeInfo);
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        FeatureTypeInfo ftInfo = (FeatureTypeInfo)xp.load(((Object)((Object)this)).getClass().getResourceAsStream("/featuretype.xml"), FeatureTypeInfoImpl.class);
        ftInfo.setStore((StoreInfo)storeInfo);
        String actualNativeSRS = ftInfo.getSRS();
        this.getCatalog().add((ResourceInfo)ftInfo);
        LayerInfo layerInfo = this.getCatalog().getLayerByName(MockData.LINES.getLocalPart());
        layerInfo.setResource((ResourceInfo)ftInfo);
        DataAccess dac = ftInfo.getStore().getDataStore(null);
        RetypingDataStore retypingDS = (RetypingDataStore)dac;
        WFSDataStore wfsDS = (WFSDataStore)retypingDS.getWrapped();
        wfsDS.getWfsClient().setHttpClient((HTTPClient)client);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layerInfo, false));
        tester.clickLink("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:find", true);
        Assert.assertNotNull((Object)layerInfo.getResource().getMetadata().get((Object)"OTHER_SRS"));
        tester.clickLink("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:popup:modal:overlay:dialog:content:content:table:listContainer:items:1:itemProperties:0:component:link", true);
        String newNativeSRS = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:srs").getDefaultModelObjectAsString();
        Assert.assertFalse((boolean)newNativeSRS.equalsIgnoreCase(actualNativeSRS));
        Assert.assertTrue((boolean)newNativeSRS.equalsIgnoreCase("urn:ogc:def:crs:EPSG::4326"));
        FormTester ft = tester.newFormTester("publishedinfo");
        ft.submit("save");
        String savedSRS = this.getCatalog().getLayerByName(layerInfo.getName()).getResource().getSRS();
        Assert.assertFalse((boolean)savedSRS.equalsIgnoreCase(actualNativeSRS));
    }

    @Test
    public void testNullSRIDResource() throws IOException {
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(LINES));
        Assert.assertNotNull((Object)layer);
        ResourceInfo ft = layer.getResource();
        ft.setSRS(null);
        ft.setNativeCRS(null);
        catalog.save(ft);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        tester.assertNoErrorMessage();
        String nativeSRSTextFieldValue = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:srs").getDefaultModelObjectAsString();
        Assert.assertTrue((boolean)nativeSRSTextFieldValue.isEmpty());
        tester.assertInvisible("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:find");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecurityTabInactiveWithNoDeafaultAccessManager() {
        TestResourceAccessManager manager = new TestResourceAccessManager();
        SecureCatalogImpl oldSc = (SecureCatalogImpl)GeoServerExtensions.bean((String)"secureCatalog");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.getCatalog(), (ResourceAccessManager)manager){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }
        };
        applicationContext.getBeanFactory().destroyBean((Object)"secureCatalog");
        GeoServerExtensionsHelper.clear();
        GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)sc, (Class[])new Class[]{SecureCatalogImpl.class});
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(TIMERANGES));
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        try {
            TabbedPanel tabs = (TabbedPanel)tester.getComponentFromLastRenderedPage("publishedinfo:tabs");
            Assert.assertEquals((long)3L, (long)tabs.getTabs().size());
        }
        catch (Throwable throwable) {
            applicationContext.getBeanFactory().destroyBean((Object)"secureCatalog");
            GeoServerExtensionsHelper.clear();
            GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)oldSc, (Class[])new Class[]{SecureCatalogImpl.class});
            throw throwable;
        }
        applicationContext.getBeanFactory().destroyBean((Object)"secureCatalog");
        GeoServerExtensionsHelper.clear();
        GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)oldSc, (Class[])new Class[]{SecureCatalogImpl.class});
    }

    @Test
    public void testWMTSOtherCRS() throws IOException {
        String baseURL = "http://mock.test.geoserver.org";
        MockHttpClient client = new MockHttpClient();
        Catalog catalog = this.getCatalog();
        URL descURL = new URL(baseURL + "/wmts?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS");
        client.expectGet(descURL, (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("/wmts_getCaps.xml"), "text/xml", new String[0]));
        TestHttpClientProvider.bind((HTTPClient)client, (URL)descURL);
        WMTSStoreInfoImpl storeInfo = new WMTSStoreInfoImpl(this.getCatalog());
        storeInfo.setName("Mock WMTS Store");
        storeInfo.setCapabilitiesURL(descURL.toString());
        storeInfo.setConnectTimeout(60);
        storeInfo.setMaxConnections(10);
        storeInfo.setDateCreated(new Date());
        storeInfo.setDateModified(new Date());
        catalog.add((StoreInfo)storeInfo);
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        WMTSLayerInfo wmtsInfo = (WMTSLayerInfo)xp.load(((Object)((Object)this)).getClass().getResourceAsStream("/wmtsLayerInfo.xml"), WMTSLayerInfo.class);
        String actualNativeSRS = wmtsInfo.getSRS();
        wmtsInfo.setStore((StoreInfo)storeInfo);
        catalog.add((ResourceInfo)wmtsInfo);
        LayerInfo layerInfo = (LayerInfo)xp.load(((Object)((Object)this)).getClass().getResourceAsStream("/wmtsLayer.xml"), LayerInfo.class);
        layerInfo.setResource((ResourceInfo)wmtsInfo);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layerInfo, true));
        tester.clickLink("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:find");
        Assert.assertNotNull((Object)layerInfo.getResource().getMetadata().get((Object)"OTHER_SRS"));
        tester.clickLink("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:popup:modal:overlay:dialog:content:content:table:listContainer:items:1:itemProperties:0:component:link", true);
        String newNativeSRS = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:srs").getDefaultModelObjectAsString();
        Assert.assertFalse((boolean)newNativeSRS.equalsIgnoreCase(actualNativeSRS));
    }

    @Test
    public void testWMTSOtherCRSUrnFormat() throws IOException {
        Catalog catalog = this.getCatalog();
        URL descURL = this.configureMockWMTSCapClient();
        WMTSStoreInfo storeInfo = this.configureWMTSStoreInfo(catalog, descURL, "WMTS Store Urn");
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.setStore((StoreInfo)storeInfo);
        WMTSLayerInfo wmtsLayerInfo = builder.buildWMTSLayer("topowebb_nedtonad");
        LayerInfo layerInfo = builder.buildLayer((ResourceInfo)wmtsLayerInfo);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layerInfo, true));
        tester.clickLink("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:find");
        Assert.assertNotNull((Object)layerInfo.getResource().getMetadata().get((Object)"OTHER_SRS"));
        DataView epsgContainer = (DataView)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:popup:modal:overlay:dialog:content:content:table:listContainer:items");
        Assert.assertEquals((long)3L, (long)epsgContainer.size());
        Component epsgComponent1 = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:popup:modal:overlay:dialog:content:content:table:listContainer:items:1:itemProperties:0:component:link:label");
        Component epsgComponent2 = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:popup:modal:overlay:dialog:content:content:table:listContainer:items:2:itemProperties:0:component:link:label");
        Component epsgComponent3 = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:popup:modal:overlay:dialog:content:content:table:listContainer:items:3:itemProperties:0:component:link:label");
        Assert.assertEquals((Object)"urn:ogc:def:crs:EPSG::3006", (Object)epsgComponent1.getDefaultModel().getObject());
        Assert.assertEquals((Object)"EPSG:3857", (Object)epsgComponent2.getDefaultModel().getObject());
        Assert.assertEquals((Object)"EPSG:3006", (Object)epsgComponent3.getDefaultModel().getObject());
    }

    @Test
    public void testUrnOgcSRIDResource() throws Exception {
        String urnOgc = "urn:ogc:def:crs:EPSG::4326";
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(LINES));
        Assert.assertNotNull((Object)layer);
        ResourceInfo ft = layer.getResource();
        ft.setSRS(urnOgc);
        ft.setNativeCRS(CRS.decode((String)urnOgc));
        catalog.save(ft);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        tester.assertNoErrorMessage();
        String nativeSRSTextFieldValue = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:srs").getDefaultModelObjectAsString();
        Assert.assertEquals((String)"Asserting EPSG code", (Object)"EPSG:4326", (Object)nativeSRSTextFieldValue);
    }

    @Test
    public void testInternationalContent() {
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        String layerId = this.getLayerId(MockData.BASIC_POLYGONS);
        LayerInfo layer = catalog.getLayerByName(layerId);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", "change");
        form.select("tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international title");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:addNew", "click");
        form.select("tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international title");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:2:component:remove", "click");
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", "change");
        form.select("tabs:panel:theList:0:content:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international abstract");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:titleAndAbstract:internationalAbstract:container:addNew", "click");
        form.select("tabs:panel:theList:0:content:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international abstract");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:2:component:remove", "click");
        form = tester.newFormTester("publishedinfo");
        form.submit("save");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testDuplicateNullEntry() {
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        String layerId = this.getLayerId(MockData.FIFTEEN);
        LayerInfo layer = catalog.getLayerByName(layerId);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", "change");
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international title");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:addNew", "click");
        tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:theList:0:content:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international title");
        form.submit("save");
        tester.assertErrorMessages(new Serializable[]{"There are more than one entries for the same language in one of the i18n fields. Duplicate language is empty"});
    }

    @Test
    public void testUrnOgcDefaultSRID() throws Exception {
        String baseURL = "http://mock.test.geoserver.org";
        MockHttpClient client = new MockHttpClient();
        Catalog catalog = this.getCatalog();
        URL descURL = new URL(baseURL + "/wmts?REQUEST=GetCapabilities&VERSION=1.1.0&SERVICE=WMS");
        client.expectGet(descURL, (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("/wms_getCaps_CRS.xml"), "text/xml", new String[0]));
        TestHttpClientProvider.bind((HTTPClient)client, (URL)descURL);
        WMSStoreInfoImpl storeInfo = new WMSStoreInfoImpl(this.getCatalog());
        storeInfo.setName("Another Mock WMS Store");
        storeInfo.setCapabilitiesURL(descURL.toString());
        storeInfo.setConnectTimeout(60);
        storeInfo.setMaxConnections(10);
        storeInfo.setDateCreated(new Date());
        storeInfo.setDateModified(new Date());
        catalog.add((StoreInfo)storeInfo);
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.setStore((StoreInfo)storeInfo);
        WMSLayerInfo wmtsLayerInfo = builder.buildWMSLayer("world4326");
        LayerInfo layerInfo = builder.buildLayer(wmtsLayerInfo);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layerInfo, true));
        String nativeSRSTextFieldValue = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:srs").getDefaultModelObjectAsString();
        Assert.assertEquals((Object)"EPSG:3395", (Object)nativeSRSTextFieldValue);
    }

    @Test
    public void testConsistentUpdateWMTSBbox() throws IOException, FactoryException {
        LayerInfo layerInfo = this.setUpWMTSLayer("WMTS Store BBOX");
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layerInfo, true));
        ReferencedEnvelope oldEnvelope = (ReferencedEnvelope)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeBoundingBox").getDefaultModel().getObject();
        tester.clickLink("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:find");
        Assert.assertNotNull((Object)layerInfo.getResource().getMetadata().get((Object)"OTHER_SRS"));
        tester.clickLink("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeSRS:popup:modal:overlay:dialog:content:content:table:listContainer:items:1:itemProperties:0:component:link", true);
        tester.clickLink("publishedinfo:tabs:panel:theList:0:content:referencingForm:computeNative", true);
        ReferencedEnvelope newEnvelope = (ReferencedEnvelope)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:theList:0:content:referencingForm:nativeBoundingBox").getDefaultModel().getObject();
        ReferencedEnvelope envelope = new ReferencedEnvelope(4305696.0, 8500000.0, -1200000.0, 2994304.0, CRS.decode((String)"urn:ogc:def:crs:EPSG::3006"));
        Assert.assertNotEquals((Object)oldEnvelope, (Object)newEnvelope);
        Assert.assertEquals((Object)envelope, (Object)newEnvelope);
    }

    private LayerInfo setUpWMTSLayer(String storeName) throws IOException {
        Catalog catalog = this.getCatalog();
        URL descURL = this.configureMockWMTSCapClient();
        WMTSStoreInfo storeInfo = this.configureWMTSStoreInfo(catalog, descURL, storeName);
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        WMTSLayerInfo wmtsInfo = (WMTSLayerInfo)xp.load(((Object)((Object)this)).getClass().getResourceAsStream("/wmtsLayerInfo.xml"), WMTSLayerInfo.class);
        wmtsInfo.setStore((StoreInfo)storeInfo);
        catalog.add((ResourceInfo)wmtsInfo);
        LayerInfo layerInfo = (LayerInfo)xp.load(((Object)((Object)this)).getClass().getResourceAsStream("/wmtsLayer.xml"), LayerInfo.class);
        layerInfo.setResource((ResourceInfo)wmtsInfo);
        return layerInfo;
    }

    private URL configureMockWMTSCapClient() throws IOException {
        String baseURL = "http://mock.test.geoserver.org";
        MockHttpClient client = new MockHttpClient();
        URL descURL = new URL(baseURL + "/wmts?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS");
        client.expectGet(descURL, (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("/wmts_getCaps.xml"), "text/xml", new String[0]));
        TestHttpClientProvider.bind((HTTPClient)client, (URL)descURL);
        return descURL;
    }

    private WMTSStoreInfo configureWMTSStoreInfo(Catalog catalog, URL capURL, String name) {
        WMTSStoreInfoImpl storeInfo = new WMTSStoreInfoImpl(this.getCatalog());
        storeInfo.setName(name);
        storeInfo.setCapabilitiesURL(capURL.toString());
        storeInfo.setConnectTimeout(60);
        storeInfo.setMaxConnections(10);
        storeInfo.setDateCreated(new Date());
        storeInfo.setDateModified(new Date());
        catalog.add((StoreInfo)storeInfo);
        return storeInfo;
    }

    @Test
    public void testCustomizeAttributes() {
        String layerId = this.getLayerId(MockData.GENERICENTITY);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        tester.assertLabel("publishedinfoname", layerId);
        tester.assertComponent("publishedinfo:tabs:panel:theList:0:content", BasicResourceConfig.class);
        String attributesPanel = "publishedinfo:tabs:panel:theList:1:content:attributePanel:";
        tester.assertVisible(attributesPanel + "attributesTable");
        tester.assertInvisible(attributesPanel + "attributesEditor");
        String attribute0 = attributesPanel + "attributesTable:attributes:0:";
        tester.assertModelValue(attribute0 + "name", (Object)"description");
        tester.assertModelValue(attribute0 + "type", (Object)"String");
        tester.assertModelValue(attribute0 + "nillable", (Object)"true");
        tester.assertModelValue(attribute0 + "minmax", (Object)"0/1");
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:theList:1:content:attributePanel:customizeFeatureType", "true");
        tester.executeAjaxEvent(attributesPanel + "customizeFeatureType", "click");
        tester.assertInvisible(attributesPanel + "attributesTable");
        tester.assertVisible(attributesPanel + "attributesEditor");
        String edit1 = "publishedinfo:tabs:panel:theList:1:content:attributePanel:attributesEditor:table:listContainer:items:1:itemProperties:";
        tester.assertModelValue(edit1 + "2:component:text", (Object)"description");
        tester.assertModelValue(edit1 + "3:component:type", String.class);
        tester.assertModelValue(edit1 + "4:component:area", (Object)"description");
        tester.assertModelValue(edit1 + "5:component:description", null);
        tester.assertModelValue(edit1 + "6:component:check", (Object)true);
        String formEdit1 = "tabs:panel:theList:1:content:attributePanel:attributesEditor:table:listContainer:items:1:itemProperties:";
        form.setValue(formEdit1 + "2:component:text", "abstract");
        String cql = "Concatenate(description, ' and more!')";
        form.setValue(formEdit1 + "4:component:area", cql);
        form.setValue(formEdit1 + "5:component:description", "attribute described");
        form.setValue(formEdit1 + "6:component:check", "false");
        form.submit("apply");
        tester.assertNoErrorMessage();
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(layerId);
        List attributes = fti.getAttributes();
        Assert.assertNotNull((Object)attributes);
        Assert.assertEquals((long)6L, (long)attributes.size());
        AttributeTypeInfo att = (AttributeTypeInfo)attributes.get(0);
        Assert.assertEquals((Object)"abstract", (Object)att.getName());
        Assert.assertEquals((Object)"attribute described", (Object)att.getDescription().toString(GeoServerDefaultLocale.get()));
        Assert.assertEquals((Object)cql, (Object)att.getSource());
    }

    @Test
    public void testCustomizeAttributesJdbc() throws Exception {
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName("foo");
        ds.setWorkspace(cat.getDefaultWorkspace());
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        params.put("database", ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath() + "/foo");
        cat.add((StoreInfo)ds);
        SimpleFeatureSource fs1 = this.getFeatureSource(SystemTestData.FORESTS);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fs1.getSchema());
        store.createSchema((FeatureType)tb.buildFeatureType());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        SimpleFeatureStore fs = (SimpleFeatureStore)store.getFeatureSource("Forests");
        fs.addFeatures((FeatureCollection)fs1.getFeatures());
        this.addFeature(fs, "MULTIPOLYGON (((0.008151604330777 -0.0023208963631571, 0.0086527358638763 -0.0012374917185382, 0.0097553137885805 -0.0004505798694767, 0.0156132468328575 0.001226912691216, 0.0164282119026783 0.0012863836826631, 0.0171241513076058 0.0011195104764988, 0.0181763809803841 0.0003258121477801, 0.018663180519973 -0.0007914339515293, 0.0187 -0.0054, 0.0185427596344991 -0.0062643098258021, 0.0178950534559435 -0.0072336706251426, 0.0166538015456463 -0.0078538015456464, 0.0160336706251426 -0.0090950534559435, 0.0150643098258021 -0.0097427596344991, 0.0142 -0.0099, 0.0086 -0.0099, 0.0077356901741979 -0.0097427596344991, 0.0067663293748574 -0.0090950534559435, 0.0062572403655009 -0.0082643098258021, 0.0061 -0.0074, 0.0061055767515099 -0.0046945371967831, 0.0062818025956546 -0.0038730531083409, 0.0066527358638763 -0.0032374917185382, 0.0072813143786463 -0.0026800146279973, 0.008151604330777 -0.0023208963631571)))", "110", "Foo Forest");
        this.addFeature(fs, "MULTIPOLYGON (((-0.0023852705061082 -0.005664537521815, -0.0026781637249217 -0.0063716443030016, -0.0033852705061082 -0.006664537521815, -0.0040923772872948 -0.0063716443030016, -0.0043852705061082 -0.005664537521815, -0.0040923772872947 -0.0049574307406285, -0.0033852705061082 -0.004664537521815, -0.0026781637249217 -0.0049574307406285, -0.0023852705061082 -0.005664537521815)))", "111", "Bar Forest");
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)fs);
        VirtualTable vt = new VirtualTable("test", "SELECT FID,NAD FROM \"Forests\"");
        ft.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
        cat.add((ResourceInfo)ft);
        LayerInfo layer = cat.getFactory().createLayer();
        layer.setResource((ResourceInfo)ft);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        String text = tester.getLastResponse().getDocument();
        Assert.assertTrue((boolean)text.contains("gs:Forests"));
        Assert.assertTrue((boolean)text.contains("Basic Resource Info"));
        Assert.assertTrue((boolean)text.contains("Feature Type Details"));
        Assert.assertTrue((boolean)text.contains("Edit sql view"));
        Assert.assertTrue((boolean)text.contains("Failed to load attribute list, internal error is: Column NAD not found"));
        VirtualTable vt1 = new VirtualTable("test", "SELECT FID,NAME FROM \"Forests\"");
        ft.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt1);
        LayerInfo layer1 = cat.getFactory().createLayer();
        layer1.setResource((ResourceInfo)ft);
        tester.startPage((Page)new ResourceConfigurationPage(layer1, false));
        String text1 = tester.getLastResponse().getDocument();
        Assert.assertTrue((boolean)text1.contains("gs:Forests"));
        Assert.assertTrue((boolean)text1.contains("Basic Resource Info"));
        Assert.assertTrue((boolean)text1.contains("Feature Type Details"));
        Assert.assertTrue((boolean)text1.contains("Edit sql view"));
        Assert.assertFalse((boolean)text1.contains("Failed to load attribute list, internal error is: Column NAD not found"));
    }

    void addFeature(SimpleFeatureStore store, String wkt, Object ... atts) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder((SimpleFeatureType)store.getSchema());
        b.add((Object)new WKTReader().read(wkt));
        for (Object att : atts) {
            b.add(att);
        }
        DefaultFeatureCollection features = new DefaultFeatureCollection(null, null);
        features.add(b.buildFeature(null));
        store.addFeatures((FeatureCollection)features);
    }

    @Test
    public void testRenameAndMove() {
        String layerId = this.getLayerId(MockData.GENERICENTITY);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        this.login();
        tester.startPage((Page)new ResourceConfigurationPage(layer, false));
        tester.assertLabel("publishedinfoname", layerId);
        tester.assertComponent("publishedinfo:tabs:panel:theList:0:content", BasicResourceConfig.class);
        String attributesPanel = "publishedinfo:tabs:panel:theList:1:content:attributePanel:";
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:theList:1:content:attributePanel:customizeFeatureType", "true");
        tester.executeAjaxEvent(attributesPanel + "customizeFeatureType", "click");
        tester.assertInvisible(attributesPanel + "attributesTable");
        tester.assertVisible(attributesPanel + "attributesEditor");
        String firstItemProperties = "tabs:panel:theList:1:content:attributePanel:attributesEditor:table:listContainer:items:1:itemProperties";
        form.setValue(firstItemProperties + ":2:component:text", "abstract");
        tester.executeAjaxEvent("publishedinfo:" + firstItemProperties + ":2:component:text", "blur");
        tester.executeAjaxEvent("publishedinfo:" + firstItemProperties + ":1:component:down:link", "click");
        form.submit("apply");
        tester.assertNoErrorMessage();
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(layerId);
        List attributes = fti.getAttributes();
        Assert.assertNotNull((Object)attributes);
        Assert.assertEquals((long)6L, (long)attributes.size());
        AttributeTypeInfo att = (AttributeTypeInfo)attributes.get(1);
        Assert.assertEquals((Object)"abstract", (Object)att.getName());
        Assert.assertEquals((Object)"description", (Object)att.getSource());
    }
}

