/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.geoserver.security.AdminRequest;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.AbstractDataAccessPage;
import org.geoserver.web.data.store.DataAccessNewPage;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DataAccessNewPageDatabaseTest
extends GeoServerWicketTestSupport {
    final JDBCDataStoreFactory dataStoreFactory = new PostgisNGDataStoreFactory();

    private AbstractDataAccessPage startPage() {
        AdminRequest.start((Object)new Object());
        this.login();
        DataAccessNewPage page = new DataAccessNewPage(this.dataStoreFactory.getDisplayName());
        tester.startPage((Page)page);
        return page;
    }

    @After
    public void clearAdminRequest() {
        AdminRequest.finish();
    }

    @Test
    public void testPageRendersOnLoad() {
        this.startPage();
        tester.assertLabel("dataStoreForm:storeType", this.dataStoreFactory.getDisplayName());
        tester.assertLabel("dataStoreForm:storeTypeDescription", this.dataStoreFactory.getDescription());
        tester.assertComponent("dataStoreForm:workspacePanel", WorkspacePanel.class);
    }

    @Test
    public void testDbtypeParameterHidden() {
        this.startPage();
        MarkupContainer container = (MarkupContainer)tester.getComponentFromLastRenderedPage("dataStoreForm:parametersPanel:parameters:0");
        Assert.assertEquals((Object)"dbtype", (Object)container.getDefaultModelObject());
        Assert.assertFalse((boolean)container.get("parameterPanel").isVisible());
    }
}

