/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.DataAccessNewPage;
import org.geoserver.web.data.store.NewDataPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NewDataPageTest
extends GeoServerWicketTestSupport {
    @Before
    public void init() {
        this.login();
        tester.startPage((Page)new NewDataPage());
    }

    @Test
    public void testLoad() {
        tester.assertRenderedPage(NewDataPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("storeForm:vectorResources", ListView.class);
        tester.assertComponent("storeForm:rasterResources", ListView.class);
    }

    @Test
    public void testLoadWithNoWorkspaces() {
        tester.startPage((Page)new NewDataPageWithFakeCatalog());
        tester.assertRenderedPage(NewDataPageWithFakeCatalog.class);
        String expectedErrMsg = new ResourceModel("NewDataPage.noWorkspacesErrorMessage").getObject();
        Assert.assertNotNull((Object)expectedErrMsg);
        tester.assertErrorMessages((Serializable[])new String[]{expectedErrMsg});
    }

    @Test
    public void testClickLink() {
        Label label = (Label)this.findComponentByContent((MarkupContainer)tester.getLastRenderedPage(), "Properties", Label.class);
        tester.clickLink(label.getParent().getPath().substring(2));
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(DataAccessNewPage.class);
        tester.assertModelValue("dataStoreForm:storeType", (Object)"Properties");
    }

    private static class NewDataPageWithFakeCatalog
    extends NewDataPage {
        private NewDataPageWithFakeCatalog() {
        }

        protected Catalog getCatalog() {
            return new CatalogImpl();
        }
    }
}

