/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.WMSStoreNewPage;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WMSStoreNewPageTest
extends GeoServerWicketTestSupport {
    private static final boolean debugMode = false;
    private static WireMockServer wmsService;
    private static String capabilities;

    @BeforeClass
    public static void beforeClass() throws Exception {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().dynamicPort();
        wmsService = new WireMockServer((Options)config);
        wmsService.start();
        capabilities = "http://localhost:" + wmsService.port() + "/geoserver/wms?REQUEST=GetCapabilities&VERSION=1.3.0&SERVICE=WMS";
        wmsService.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/geoserver/wms?REQUEST=GetCapabilities&VERSION=1.3.0&SERVICE=WMS")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBodyFile("caps130.xml")));
    }

    @AfterClass
    public static void afterClass() throws Exception {
        wmsService.stop();
    }

    @Before
    public void init() {
    }

    private WMSStoreNewPage startPage() {
        this.login();
        WMSStoreNewPage page = new WMSStoreNewPage();
        tester.startPage((Page)page);
        return page;
    }

    @Test
    public void testPageRendersOnLoad() {
        this.startPage();
        tester.assertComponent("form:workspacePanel", WorkspacePanel.class);
    }

    @Test
    public void testInitialModelState() {
        WMSStoreNewPage page = this.startPage();
        Assert.assertNull((Object)page.getDefaultModelObject());
        tester.assertModelValue("form:enabledPanel:paramValue", (Object)Boolean.TRUE);
        tester.assertModelValue("form:workspacePanel:border:border_body:paramValue", (Object)this.getCatalog().getDefaultWorkspace());
    }

    @Test
    public void testSaveNewStore() {
        WMSStoreNewPage page = this.startPage();
        Assert.assertNull((Object)page.getDefaultModelObject());
        Catalog catalog = this.getCatalog();
        WMSStoreInfo info = catalog.getFactory().createWebMapServer();
        info.setName("foo");
        tester.assertNoErrorMessage();
        FormTester form = tester.newFormTester("form");
        form.select("workspacePanel:border:border_body:paramValue", 4);
        Component wsDropDown = tester.getComponentFromLastRenderedPage("form:workspacePanel:border:border_body:paramValue");
        tester.executeAjaxEvent(wsDropDown, "change");
        form.setValue("namePanel:border:border_body:paramValue", "foo");
        form.setValue("capabilitiesURL:border:border_body:paramValue", "http://foo");
        tester.clickLink("form:save", true);
        List feedback = tester.getFeedbackMessages(IFeedbackMessageFilter.ALL);
        Assert.assertEquals((long)1L, (long)feedback.size());
        Serializable msg = ((FeedbackMessage)feedback.get(0)).getMessage();
        Assert.assertTrue((boolean)msg.toString().startsWith("Connection test failed:"));
        catalog.save((StoreInfo)info);
        Assert.assertNotNull((Object)info.getId());
        WMSStoreInfo expandedStore = catalog.getResourcePool().clone(info, true);
        Assert.assertNotNull((Object)expandedStore.getId());
        Assert.assertNotNull((Object)expandedStore.getCatalog());
        catalog.validate((StoreInfo)expandedStore, false).throwIfInvalid();
    }

    @Test
    public void testSaveNewStoreEntityExpansion() throws Exception {
        WMSStoreNewPage page = this.startPage();
        Assert.assertNull((Object)page.getDefaultModelObject());
        Catalog catalog = this.getCatalog();
        WMSStoreInfo info = this.getCatalog().getFactory().createWebMapServer();
        URL url = ((Object)((Object)this)).getClass().getResource("1.3.0Capabilities-xxe.xml");
        info.setName("bar");
        tester.assertNoErrorMessage();
        FormTester form = tester.newFormTester("form");
        form.select("workspacePanel:border:border_body:paramValue", 4);
        Component wsDropDown = tester.getComponentFromLastRenderedPage("form:workspacePanel:border:border_body:paramValue");
        tester.executeAjaxEvent(wsDropDown, "change");
        form.setValue("namePanel:border:border_body:paramValue", "bar");
        form.setValue("capabilitiesURL:border:border_body:paramValue", url.toExternalForm());
        tester.clickLink("form:save", true);
        tester.assertErrorMessages(new Serializable[]{"Connection test failed: Error while parsing XML."});
        this.getGeoServer().reload();
        tester.clickLink("form:save", true);
        tester.assertErrorMessages(new Serializable[]{"Connection test failed: Error while parsing XML."});
        catalog.save((StoreInfo)info);
        Assert.assertNotNull((Object)info.getId());
        WMSStoreInfo expandedStore = catalog.getResourcePool().clone(info, true);
        Assert.assertNotNull((Object)expandedStore.getId());
        Assert.assertNotNull((Object)expandedStore.getCatalog());
        catalog.validate((StoreInfo)expandedStore, false).throwIfInvalid();
    }

    @Test
    public void testDisableOnConnFailureCheckbox() {
        this.startPage();
        FormTester form = tester.newFormTester("form");
        form.select("workspacePanel:border:border_body:paramValue", 4);
        Component wsDropDown = tester.getComponentFromLastRenderedPage("form:workspacePanel:border:border_body:paramValue");
        tester.executeAjaxEvent(wsDropDown, "change");
        form.setValue("namePanel:border:border_body:paramValue", "fooAutoDisable");
        form.setValue("capabilitiesURL:border:border_body:paramValue", capabilities);
        Component component = tester.getComponentFromLastRenderedPage("form:disableOnConnFailurePanel:paramValue");
        CheckBox checkBox = (CheckBox)component;
        Assert.assertFalse((boolean)Boolean.valueOf(checkBox.getInput()));
        form.setValue("disableOnConnFailurePanel:paramValue", true);
        form.submit("save");
        tester.assertNoErrorMessage();
        Catalog catalog = this.getCatalog();
        Assert.assertTrue((boolean)((WMSStoreInfo)catalog.getStoreByName("fooAutoDisable", WMSStoreInfo.class)).isDisableOnConnFailure());
    }
}

