/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import org.apache.wicket.markup.repeater.data.DataView;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.data.workspace.WorkspaceProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkspacePageTest
extends GeoServerWicketTestSupport {
    @Before
    public void init() {
        this.login();
        tester.startPage(WorkspacePage.class);
    }

    @Test
    public void testLoad() {
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertEquals((long)dv.size(), (long)this.getCatalog().getWorkspaces().size());
        WorkspaceInfo ws = (WorkspaceInfo)dv.getDataProvider().iterator(0L, 1L).next();
        Assert.assertEquals((Object)"cdf", (Object)ws.getName());
    }

    @Test
    public void testTimeColumnsToggle() {
        GeoServerInfo info = this.getGeoServerApplication().getGeoServer().getGlobal();
        info.getSettings().setShowCreatedTimeColumnsInAdminList(true);
        info.getSettings().setShowModifiedTimeColumnsInAdminList(true);
        this.getGeoServerApplication().getGeoServer().save(info);
        this.login();
        tester.assertRenderedPage(WorkspacePage.class);
        tester.assertNoErrorMessage();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Assert.assertTrue((boolean)(dv.getDataProvider() instanceof WorkspaceProvider));
        WorkspaceProvider provider = (WorkspaceProvider)dv.getDataProvider();
        Assert.assertTrue((boolean)provider.getProperties().contains(WorkspaceProvider.CREATED_TIMESTAMP));
        Assert.assertTrue((boolean)provider.getProperties().contains(WorkspaceProvider.MODIFIED_TIMESTAMP));
    }
}

