/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AccessDataRuleInfoManagerTest
extends GeoServerWicketTestSupport {
    AccessDataRuleInfoManager ruleInfoMan;
    WorkspaceInfo ws;
    DataAccessRuleDAO dao;

    @Before
    public void setUp() {
        this.ruleInfoMan = new AccessDataRuleInfoManager();
        this.ws = this.getCatalog().getWorkspaceByName("cite");
        this.dao = DataAccessRuleDAO.get();
    }

    @Test
    public void testWsAccessDataRuleUpdate() throws IOException {
        Set dataRules = this.ruleInfoMan.getResourceRule(this.ws.getName(), (CatalogInfo)this.ws);
        Assert.assertTrue((boolean)dataRules.isEmpty());
        Set availableRoles = this.ruleInfoMan.getAvailableRoles();
        List rulesInfo = this.ruleInfoMan.mapTo(dataRules, availableRoles, this.ws.getName(), null);
        rulesInfo.forEach(i -> i.setRead(true));
        Set news = this.ruleInfoMan.mapFrom(rulesInfo, availableRoles, this.ws.getName(), null, false);
        this.ruleInfoMan.saveRules(dataRules, news);
        Assert.assertEquals((long)1L, (long)this.ruleInfoMan.getResourceRule(this.ws.getName(), (CatalogInfo)this.ws).size());
        this.cleanRules(this.ws.getName(), (CatalogInfo)this.ws);
    }

    @Test
    public void testLayerAccessDataRuleUpdate() throws IOException {
        LayerInfo layerInfo = this.getCatalog().getLayerByName("BasicPolygons");
        Set dataRules = this.ruleInfoMan.getResourceRule(this.ws.getName(), (CatalogInfo)layerInfo);
        Assert.assertTrue((boolean)dataRules.isEmpty());
        Set availableRoles = this.ruleInfoMan.getAvailableRoles();
        List rulesInfo = this.ruleInfoMan.mapTo(dataRules, availableRoles, this.ws.getName(), layerInfo.getName());
        rulesInfo.forEach(i -> i.setRead(true));
        Set news = this.ruleInfoMan.mapFrom(rulesInfo, availableRoles, this.ws.getName(), layerInfo.getName(), false);
        this.ruleInfoMan.saveRules(dataRules, news);
        Assert.assertEquals((long)1L, (long)this.ruleInfoMan.getResourceRule(this.ws.getName(), (CatalogInfo)layerInfo).size());
        this.cleanRules(this.ws.getName(), (CatalogInfo)layerInfo);
    }

    public void cleanRules(String wsName, CatalogInfo info) throws IOException {
        this.ruleInfoMan.removeAllResourceRules(wsName, info);
        Assert.assertEquals((long)0L, (long)this.ruleInfoMan.getResourceRule(wsName, info).size());
    }
}

