/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.system.status;

import org.apache.wicket.util.tester.TagTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.StatusPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JVMConsolePanelTest
extends GeoServerWicketTestSupport {
    @Before
    public void setupTests() {
        this.login();
        tester.getApplication().getMarkupSettings().setStripWicketTags(false);
        tester.startPage(StatusPage.class);
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:3:link", true);
    }

    @Test
    public void testCheckButtonsLink() {
        TagTester threadDumpBtn = tester.getTagByWicketId("dumpThread");
        Assert.assertNotNull((String)"dump thread button not present", (Object)threadDumpBtn);
        Assert.assertTrue((String)"href wrong on dump head button", (boolean)threadDumpBtn.getAttribute("href").contains("tabs-panel-dumpThread"));
        TagTester heapDumpBtn = tester.getTagByWicketId("dumpHeap");
        Assert.assertNotNull((String)"heap thread button not present", (Object)heapDumpBtn);
        Assert.assertTrue((String)"href wrong on dump heap button", (boolean)heapDumpBtn.getAttribute("href").contains("tabs-panel-dumpHeap"));
    }

    @Test
    public void testLoadThreadDump() {
        tester.clickLink("tabs:panel:dumpThread");
        String threadDump = tester.getTagByWicketId("dumpContent").getValue();
        Assert.assertTrue((boolean)threadDump.contains("RUNNABLE"));
    }

    @Test
    public void testLoadHeapDump() {
        tester.clickLink("tabs:panel:dumpHeap");
        String headDumpStr = tester.getTagByWicketId("dumpContent").getValue();
        Assert.assertTrue((String)"heap doesn't contains column num", (boolean)headDumpStr.contains("num"));
        Assert.assertTrue((String)"heap doesn't contains column instances", (boolean)headDumpStr.contains("#instances"));
        Assert.assertTrue((String)"heap doesn't contains column bytes", (boolean)headDumpStr.contains("#bytes"));
    }
}

