/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;

public class EnvelopePanelTest
extends GeoServerWicketTestSupport {
    @Test
    public void testEditPlain() throws Exception {
        ReferencedEnvelope e = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tester.startPage((Page)new FormTestPage(id -> new EnvelopePanel(id, e)));
        tester.assertComponent("form", Form.class);
        FormTester ft = tester.newFormTester("form");
        Assert.assertEquals((Object)"-180", (Object)ft.getTextComponentValue("panel:minX"));
        Assert.assertEquals((Object)"-90", (Object)ft.getTextComponentValue("panel:minY"));
        Assert.assertEquals((Object)"180", (Object)ft.getTextComponentValue("panel:maxX"));
        Assert.assertEquals((Object)"90", (Object)ft.getTextComponentValue("panel:maxY"));
        EnvelopePanel ep = (EnvelopePanel)tester.getComponentFromLastRenderedPage("form:panel");
        Assert.assertEquals((Object)e, (Object)ep.getModelObject());
        ft.setValue("panel:minX", "-2");
        ft.setValue("panel:minY", "-2");
        ft.setValue("panel:maxX", "2");
        ft.setValue("panel:maxY", "2");
        ft.submit();
        Assert.assertEquals((Object)new Envelope(-2.0, 2.0, -2.0, 2.0), (Object)ep.getModelObject());
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)((ReferencedEnvelope)ep.getModelObject()).getCoordinateReferenceSystem());
    }

    @Test
    public void testEditCRS() throws Exception {
        CoordinateReferenceSystem epsg4326 = CRS.decode((String)"EPSG:4326", (boolean)true);
        CoordinateReferenceSystem epsg4140 = CRS.decode((String)"EPSG:4140", (boolean)true);
        ReferencedEnvelope e = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, epsg4326);
        tester.startPage((Page)new FormTestPage(id -> {
            EnvelopePanel panel = new EnvelopePanel(id, e);
            panel.setCRSFieldVisible(true);
            return panel;
        }));
        tester.assertComponent("form", Form.class);
        FormTester ft = tester.newFormTester("form");
        Assert.assertEquals((Object)"-180", (Object)ft.getTextComponentValue("panel:minX"));
        Assert.assertEquals((Object)"-90", (Object)ft.getTextComponentValue("panel:minY"));
        Assert.assertEquals((Object)"180", (Object)ft.getTextComponentValue("panel:maxX"));
        Assert.assertEquals((Object)"90", (Object)ft.getTextComponentValue("panel:maxY"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)ft.getTextComponentValue("panel:crsContainer:crs:srs"));
        EnvelopePanel ep = (EnvelopePanel)tester.getComponentFromLastRenderedPage("form:panel");
        Assert.assertEquals((Object)e, (Object)ep.getModelObject());
        ft.setValue("panel:minX", "-2");
        ft.setValue("panel:minY", "-2");
        ft.setValue("panel:maxX", "2");
        ft.setValue("panel:maxY", "2");
        ft.setValue("panel:crsContainer:crs:srs", "EPSG:4140");
        ft.submit();
        Assert.assertEquals((Object)new Envelope(-2.0, 2.0, -2.0, 2.0), (Object)ep.getModelObject());
        Assert.assertEquals((Object)epsg4140, (Object)((ReferencedEnvelope)ep.getModelObject()).getCoordinateReferenceSystem());
    }

    @Test
    public void testDecimalsPreserved() throws Exception {
        ReferencedEnvelope e = new ReferencedEnvelope(-1.0E-11, 1.0E-9, -9.0E-11, 9.0E-11, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tester.startPage((Page)new FormTestPage(id -> new EnvelopePanel(id, e)));
        tester.assertComponent("form", Form.class);
        FormTester ft = tester.newFormTester("form");
        Assert.assertEquals((Object)"-0.00000000001", (Object)ft.getTextComponentValue("panel:minX"));
        Assert.assertEquals((Object)"-0.00000000009", (Object)ft.getTextComponentValue("panel:minY"));
        Assert.assertEquals((Object)"0.000000001", (Object)ft.getTextComponentValue("panel:maxX"));
        Assert.assertEquals((Object)"0.00000000009", (Object)ft.getTextComponentValue("panel:maxY"));
    }
}

