/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.browser.ExtensionFileFilter;
import org.geoserver.web.wicket.browser.FileDataView;
import org.geoserver.web.wicket.browser.FileProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileDataViewTest {
    private WicketTester tester;
    private File root;
    private File one;
    private File two;
    private File lastClicked;
    FileProvider fileProvider;

    @Before
    public void setUp() throws Exception {
        this.tester = new WicketTester();
        GeoServerWicketTestSupport.initResourceSettings(this.tester);
        this.root = new File("target/test-dataview");
        if (this.root.exists()) {
            FileUtils.deleteDirectory((File)this.root);
        }
        this.root.mkdirs();
        this.one = new File(this.root, "one.txt");
        this.one.createNewFile();
        this.two = new File(this.root, "two.sld");
        this.two.createNewFile();
        this.fileProvider = new FileProvider(this.root);
        this.tester.startPage((Page)new FormTestPage(id -> new FileDataView(id, this.fileProvider){

            protected void linkNameClicked(File file, Optional<AjaxRequestTarget> target) {
                FileDataViewTest.this.lastClicked = file;
            }
        }));
    }

    @Test
    public void testLoad() throws Exception {
        this.tester.assertRenderedPage(FormTestPage.class);
        this.tester.assertNoErrorMessage();
        this.tester.assertLabel("form:panel:fileTable:fileContent:files:1:nameLink:name", "one.txt");
        this.tester.assertLabel("form:panel:fileTable:fileContent:files:2:nameLink:name", "two.sld");
        Assert.assertEquals((long)2L, (long)((DataView)this.tester.getComponentFromLastRenderedPage("form:panel:fileTable:fileContent:files")).size());
    }

    @Test
    public void testClick() throws Exception {
        this.tester.clickLink("form:panel:fileTable:fileContent:files:1:nameLink");
        this.tester.assertRenderedPage(FormTestPage.class);
        this.tester.assertNoErrorMessage();
        Assert.assertEquals((Object)this.one, (Object)this.lastClicked);
    }

    @Test
    public void testFilter() throws Exception {
        this.fileProvider.setFileFilter((IModel)new Model((Serializable)new ExtensionFileFilter(new String[]{".txt"})));
        this.tester.startPage(this.tester.getLastRenderedPage());
        this.tester.assertLabel("form:panel:fileTable:fileContent:files:3:nameLink:name", "one.txt");
        Assert.assertEquals((long)1L, (long)((DataView)this.tester.getComponentFromLastRenderedPage("form:panel:fileTable:fileContent:files")).size());
    }

    @Test
    public void testSortByName() throws Exception {
        this.tester.clickLink("form:panel:fileTable:nameHeader:orderByLink", true);
        this.tester.clickLink("form:panel:fileTable:nameHeader:orderByLink", true);
        this.tester.assertRenderedPage(FormTestPage.class);
        this.tester.assertLabel("form:panel:fileTable:fileContent:files:5:nameLink:name", "two.sld");
        this.tester.assertLabel("form:panel:fileTable:fileContent:files:6:nameLink:name", "one.txt");
    }
}

