/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestHandler;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.browser.ExtensionFileFilter;
import org.geoserver.web.wicket.browser.FileRootsFinder;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class GeoServerFileChooserTest
extends GeoServerWicketTestSupport {
    private static final String ROLE_CITE = "ROLE_CITE";
    private static final String ROLE_SF = "ROLE_SF";
    private File root;
    private File one;
    private File two;
    private File child;
    private DefaultFileAccessManager fam;

    @Before
    public void init() throws IOException {
        this.root = new File("target/test-filechooser");
        if (this.root.exists()) {
            FileUtils.deleteDirectory((File)this.root);
        }
        this.child = new File(this.root, "child");
        this.child.mkdirs();
        this.one = new File(this.child, "one.txt");
        this.one.createNewFile();
        this.two = new File(this.child, "two.sld");
        this.two.createNewFile();
    }

    @Before
    public void cleanupRestrictions() throws Exception {
        GeoServerDataDirectory dd = this.getDataDirectory();
        Resource layerSecurity = dd.get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("*.*.r", "*");
        properties.put("*.*.w", "*");
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "everyone can read and write");
        }
        System.clearProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX);
        this.fam = (DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class, (ApplicationContext)applicationContext);
        this.fam.reload();
    }

    public void setupChooser(File file) {
        tester.startPage((Page)new FormTestPage(id -> new GeoServerFileChooser(id, (IModel)new Model((Serializable)file))));
    }

    @Test
    public void testLoad() {
        this.setupChooser(this.root);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertNoErrorMessage();
        tester.assertLabel("form:panel:fileTable:fileTable:fileContent:files:1:nameLink:name", "child/");
        Assert.assertEquals((long)1L, (long)((DataView)tester.getComponentFromLastRenderedPage("form:panel:fileTable:fileTable:fileContent:files")).size());
    }

    @Test
    public void testNullRoot() {
        this.setupChooser(null);
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertNoErrorMessage();
        tester.assertLabel("form:panel:breadcrumbs:path:0:pathItemLink:pathItem", ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getName() + "/");
    }

    @Test
    public void testInDialog() throws Exception {
        tester.startPage((Page)new FormTestPage(id -> new GeoServerDialog(id)));
        tester.assertRenderedPage(FormTestPage.class);
        tester.debugComponentTrees();
        GeoServerDialog dialog = (GeoServerDialog)tester.getComponentFromLastRenderedPage("form:panel");
        Assert.assertNotNull((Object)dialog);
        dialog.showOkCancel((AjaxRequestTarget)new AjaxRequestHandler(tester.getLastRenderedPage()), new GeoServerDialog.DialogDelegate(){

            protected Component getContents(String id) {
                return new GeoServerFileChooser(id, (IModel)new Model((Serializable)GeoServerFileChooserTest.this.root));
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                Assert.assertNotNull((Object)contents);
                Assert.assertTrue((boolean)(contents instanceof GeoServerFileChooser));
                return true;
            }
        });
        dialog.submit((AjaxRequestTarget)new AjaxRequestHandler(tester.getLastRenderedPage()));
    }

    @Test
    public void testHideFileSystem() throws Exception {
        tester.startPage((Page)new FormTestPage(id -> new GeoServerFileChooser(id, (IModel)new Model(), true)));
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertNoErrorMessage();
        DropDownChoice rootChoice = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:panel:roots");
        Assert.assertEquals((long)1L, (long)rootChoice.getChoices().size());
        Assert.assertEquals((Object)this.getDataDirectory().root(), rootChoice.getChoices().get(0));
    }

    @Test
    public void testAutocompleteDataDirectory() throws Exception {
        FileRootsFinder rootsFinder = new FileRootsFinder(true);
        this.getDataDirectory().get(new String[]{"/"}).dir();
        List values = rootsFinder.getMatches(MockData.CITE_PREFIX + "/poly", null).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"file:cite/BasicPolygons.properties", values.get(0));
        values = rootsFinder.getMatches("/styles/raster", (FileFilter)new ExtensionFileFilter(new String[]{".sld"})).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)"file:styles/raster.sld", values.get(0));
    }

    @Test
    public void testAutocompleteDirectories() throws Exception {
        FileRootsFinder rootsFinder = new FileRootsFinder(true);
        File dir = this.getDataDirectory().get(new String[]{"/"}).dir();
        String rootPath = dir.getCanonicalFile().getAbsolutePath() + File.separator;
        ExtensionFileFilter fileFilter = new ExtensionFileFilter(new String[]{".properties"});
        List values = rootsFinder.getMatches(rootPath, (FileFilter)fileFilter).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)values.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertEquals((long)new HashSet(values).size(), (long)values.size());
        MatcherAssert.assertThat(values, (Matcher)Matchers.hasItem((Object)("file://" + new File(rootPath, MockData.CITE_PREFIX).getAbsolutePath())));
        MatcherAssert.assertThat(values, (Matcher)Matchers.hasItem((Object)("file://" + new File(rootPath, MockData.SF_PREFIX).getAbsolutePath())));
    }

    @Test
    public void testAdminSandbox() throws Exception {
        File systemSandbox = new File("./target/fc-systemSandbox").getCanonicalFile();
        File citeFolder = new File(systemSandbox, MockData.CITE_PREFIX);
        File sfFolder = new File(systemSandbox, MockData.SF_PREFIX);
        citeFolder.mkdirs();
        sfFolder.mkdirs();
        System.setProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX, systemSandbox.getAbsolutePath());
        this.fam.reload();
        this.login("admin", "geoserver", new String[]{GeoServerRole.ADMIN_ROLE.getAuthority()});
        FileRootsFinder rootsFinder = new FileRootsFinder(true);
        ArrayList files = rootsFinder.getRoots();
        Assert.assertEquals(List.of(systemSandbox), (Object)files);
        List values = rootsFinder.getMatches(systemSandbox.getAbsolutePath() + File.separator, null).collect(Collectors.toList());
        Assert.assertEquals(List.of("file://" + citeFolder.getAbsoluteFile(), "file://" + sfFolder.getAbsoluteFile()), values);
    }

    @Test
    public void testWorkspaceSandbox() throws Exception {
        File sandbox = new File("./target/sandbox").getCanonicalFile();
        File citeFolder = new File(sandbox, MockData.CITE_PREFIX);
        File sfFolder = new File(sandbox, MockData.SF_PREFIX);
        File toppFolder = new File(sandbox, "topp");
        citeFolder.mkdirs();
        sfFolder.mkdirs();
        toppFolder.mkdirs();
        Resource layerSecurity = this.getDataDirectory().get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("filesystemSandbox", sandbox.getAbsolutePath());
        properties.put("cite.*.a", ROLE_CITE);
        properties.put("sf.*.a", ROLE_SF);
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "sandbox");
        }
        this.fam.reload();
        this.login("multi", "multi", new String[]{ROLE_CITE, ROLE_SF});
        FileRootsFinder rootsFinder = new FileRootsFinder(true);
        ArrayList files = rootsFinder.getRoots();
        Assert.assertEquals(List.of(citeFolder, sfFolder), (Object)files);
        List values = rootsFinder.getMatches(sandbox.getAbsolutePath() + File.separator, null).collect(Collectors.toList());
        Assert.assertEquals(List.of("file://" + citeFolder.getAbsoluteFile(), "file://" + sfFolder.getAbsoluteFile()), values);
    }
}

