/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geotools.api.filter.Filter;

class BoundedCatalogLoader<T extends CatalogInfo>
implements Serializable {
    List<T> result = new ArrayList<T>();
    boolean boundExceeded = false;
    long residualTime;

    public BoundedCatalogLoader(T item) {
        this.result.add(item);
        this.boundExceeded = false;
    }

    public BoundedCatalogLoader(Catalog catalog, Filter filter, Class<T> target, long timeout, int max) {
        long limit = System.currentTimeMillis() + timeout;
        try (CloseableIterator search = catalog.list(target, filter, Integer.valueOf(0), Integer.valueOf(max + 1), null);){
            while (System.currentTimeMillis() < limit && search.hasNext()) {
                this.result.add((CatalogInfo)search.next());
            }
        }
        this.residualTime = limit - System.currentTimeMillis();
        boolean bl = this.boundExceeded = this.residualTime <= 0L || this.result.size() > max;
        if (this.result.size() > max) {
            this.result = new ArrayList<T>(this.result.subList(0, max));
        }
    }

    public List<T> getResult() {
        return this.result;
    }

    public boolean isBoundExceeded() {
        return this.boundExceeded;
    }

    public long getResidualTime() {
        return this.residualTime;
    }
}

