/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.geoserver.catalog.Catalog;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.web.AdminComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class WorkspaceAdminComponentAuthorizer
extends AdminComponentAuthorizer {
    static final String REQUEST_CONTEXT_CACHE_KEY = "WORKSPACEADMIN_COMPONENT_AUTHORIZER_VALUE";

    @Override
    public boolean isAccessAllowed(Class<?> componentClass, Authentication authentication) {
        if (super.isAccessAllowed(componentClass, authentication)) {
            return true;
        }
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }
        Boolean workspaceAdmin = this.getCachedValue();
        if (null == workspaceAdmin) {
            workspaceAdmin = this.isWorkspaceAdmin(authentication);
            this.setCachedValue(workspaceAdmin);
        }
        return workspaceAdmin;
    }

    boolean isWorkspaceAdmin(Authentication authentication) {
        ResourceAccessManager manager = this.getAccessManager();
        return null != manager && manager.isWorkspaceAdmin(authentication, this.getCatalog());
    }

    private Catalog getCatalog() {
        return this.getSecurityManager().getCatalog();
    }

    ResourceAccessManager getAccessManager() {
        SecureCatalogImpl secureCatalog = GeoServerApplication.get().getBeanOfType(SecureCatalogImpl.class);
        if (null == secureCatalog) {
            return null;
        }
        return secureCatalog.getResourceAccessManager();
    }

    void setCachedValue(boolean workspaceAdmin) {
        RequestAttributes atts = RequestContextHolder.getRequestAttributes();
        if (null != atts) {
            atts.setAttribute(REQUEST_CONTEXT_CACHE_KEY, (Object)workspaceAdmin, 0);
        }
    }

    @Nullable
    Boolean getCachedValue() {
        RequestAttributes atts = RequestContextHolder.getRequestAttributes();
        if (null != atts) {
            return (Boolean)atts.getAttribute(REQUEST_CONTEXT_CACHE_KEY, 0);
        }
        return null;
    }
}

