/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.LayerGroupStyleImpl;
import org.geoserver.web.data.layergroup.LayerGroupStyleModel;
import org.geoserver.web.data.layergroup.LayerGroupStylePanel;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.wicket.LiveCollectionModel;

public class LayerGroupStyleConfig
extends PublishedConfigurationPanel<LayerGroupInfo> {
    private ListView<LayerGroupStyle> styleListView;
    private WebMarkupContainer listContainer;
    private DropDownChoice<LayerGroupStyle> availableStyles;
    private IModel<LayerGroupInfo> layerGroupModel;
    LiveCollectionModel<LayerGroupStyle, List<LayerGroupStyle>> listModel;
    AjaxLink<LayerGroupStyle> copyLink;

    public LayerGroupStyleConfig(String id, final IModel<LayerGroupInfo> model) {
        super(id, model);
        this.layerGroupModel = model;
        PropertyModel stylesModel = new PropertyModel(model, "layerGroupStyles");
        this.listModel = LiveCollectionModel.list(stylesModel);
        this.styleListView = new ListView<LayerGroupStyle>("styleList", this.listModel){

            protected void populateItem(ListItem<LayerGroupStyle> listItem) {
                LayerGroupStyleModel lgStyle = new LayerGroupStyleModel((IModel<LayerGroupStyle>)listItem.getModel());
                LayerGroupStylePanel stylePanel = new LayerGroupStylePanel("layerGroupStylePanel", lgStyle, (IModel)new PropertyModel((Object)model, "workspace")){

                    @Override
                    protected void handleRemoval(AjaxRequestTarget target, LayerGroupStyle style) {
                        ArrayList<LayerGroupStyle> styles = new ArrayList<LayerGroupStyle>((Collection)LayerGroupStyleConfig.this.listModel.getObject());
                        styles.removeIf(s -> s.getId().equals(style.getId()));
                        LayerGroupStyleConfig.this.listModel.setObject(styles);
                        LayerGroupStyleConfig.this.listContainer.modelChanged();
                        LayerGroupStyleConfig.this.styleListView.modelChanged();
                        LayerGroupStyleConfig.this.availableStyles.setChoices(LayerGroupStyleConfig.this.getAvailableStyles());
                        target.add(new Component[]{LayerGroupStyleConfig.this.listContainer, LayerGroupStyleConfig.this.availableStyles});
                        target.addChildren(LayerGroupStyleConfig.this.styleListView, LayerGroupStyle.class);
                    }
                };
                stylePanel.setOutputMarkupId(true);
                listItem.add(new Component[]{stylePanel});
                listItem.setOutputMarkupId(true);
            }
        };
        this.styleListView.setOutputMarkupId(true);
        this.styleListView.setReuseItems(true);
        this.add(new Component[]{this.addNewLink()});
        Component[] componentArray = new Component[1];
        this.availableStyles = this.availableStyle(this.getAvailableStyles());
        componentArray[0] = this.availableStyles;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.copyLink = this.copyLink();
        componentArray2[0] = this.copyLink;
        this.add(componentArray2);
        this.availableStyles.setOutputMarkupId(true);
        this.listContainer = new WebMarkupContainer("listContainer");
        this.listContainer.add(new Component[]{this.styleListView});
        this.listContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.listContainer});
        LayerGroupInfo.Mode mode = ((LayerGroupInfo)model.getObject()).getMode();
        this.setVisible(mode.equals((Object)LayerGroupInfo.Mode.SINGLE) || mode.equals((Object)LayerGroupInfo.Mode.OPAQUE_CONTAINER));
    }

    private DropDownChoice<LayerGroupStyle> availableStyle(List<LayerGroupStyle> styles) {
        ChoiceRenderer<LayerGroupStyle> render = new ChoiceRenderer<LayerGroupStyle>(){

            public Object getDisplayValue(LayerGroupStyle object) {
                String displayVal = object == null ? "default" : object.getName().getName();
                return displayVal;
            }
        };
        DropDownChoice dropDownChoice = new DropDownChoice("availableStyles", (IModel)new Model(), styles, (IChoiceRenderer)render);
        dropDownChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                if (LayerGroupStyleConfig.this.availableStyles.getInput() != null) {
                    LayerGroupStyle groupStyle = (LayerGroupStyle)LayerGroupStyleConfig.this.availableStyles.getModelObject();
                    LayerGroupStyleImpl newGroupStyle = new LayerGroupStyleImpl();
                    if (groupStyle == null) {
                        LayerGroupInfo groupInfo = (LayerGroupInfo)LayerGroupStyleConfig.this.layerGroupModel.getObject();
                        LayerGroupStyleConfig.this.populateStyle((LayerGroupStyle)newGroupStyle, groupInfo.getLayers(), groupInfo.getStyles());
                    } else {
                        LayerGroupStyleConfig.this.populateStyle((LayerGroupStyle)newGroupStyle, groupStyle.getLayers(), groupStyle.getStyles());
                    }
                    LayerGroupStyleConfig.this.copyLink.setModelObject((Object)newGroupStyle);
                    target.add(new Component[]{LayerGroupStyleConfig.this.availableStyles});
                }
            }
        }});
        return dropDownChoice;
    }

    private AjaxLink<LayerGroupStyle> addNewLink() {
        return new AjaxLink<LayerGroupStyle>("addNew"){

            public void onClick(AjaxRequestTarget target) {
                ArrayList<LayerGroupStyleImpl> groupStyles = LayerGroupStyleConfig.this.styleListView.getModelObject();
                groupStyles = new ArrayList<LayerGroupStyleImpl>(groupStyles);
                groupStyles.add(new LayerGroupStyleImpl());
                LayerGroupStyleConfig.this.styleListView.setModelObject(groupStyles);
                target.add(new Component[]{LayerGroupStyleConfig.this.listContainer});
                target.addChildren(LayerGroupStyleConfig.this.styleListView, LayerGroupStyle.class);
                target.addChildren(LayerGroupStyleConfig.this.styleListView, LayerGroupStylePanel.class);
            }
        };
    }

    private AjaxLink<LayerGroupStyle> copyLink() {
        return new AjaxLink<LayerGroupStyle>("copy", (IModel)new Model()){

            public void onClick(AjaxRequestTarget target) {
                LayerGroupStyle groupStyle = (LayerGroupStyle)this.getModelObject();
                if (groupStyle != null) {
                    ArrayList<LayerGroupStyleImpl> groupStyles = (ArrayList<LayerGroupStyleImpl>)LayerGroupStyleConfig.this.listModel.getObject();
                    LayerGroupStyleImpl toAdd = new LayerGroupStyleImpl();
                    toAdd.setLayers(groupStyle.getLayers());
                    toAdd.setStyles(groupStyle.getStyles());
                    groupStyles = new ArrayList<LayerGroupStyleImpl>(groupStyles);
                    groupStyles.add(toAdd);
                    LayerGroupStyleConfig.this.listModel.setObject(groupStyles);
                    target.add(new Component[]{LayerGroupStyleConfig.this.listContainer});
                    target.addChildren(LayerGroupStyleConfig.this.styleListView, LayerGroupStylePanel.class);
                } else {
                    LayerGroupStyleConfig.this.availableStyles.warn((Serializable)((Object)"Please select a style"));
                }
            }
        };
    }

    private void populateStyle(LayerGroupStyle lgStyle, List<PublishedInfo> layers, List<StyleInfo> styles) {
        for (int i = 0; i < layers.size(); ++i) {
            lgStyle.getLayers().add(layers.get(i));
            lgStyle.getStyles().add(styles.get(i));
        }
    }

    private List<LayerGroupStyle> getAvailableStyles() {
        List<LayerGroupStyle> styles = (List<LayerGroupStyle>)this.listModel.getObject();
        styles = styles.stream().filter(s -> s != null && s.getName().getName() != null).collect(Collectors.toList());
        styles.add(0, null);
        return styles;
    }
}

