/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.util.List;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

public class CheckExistingResourcesInWorkspaceValidator
implements IValidator<WorkspaceInfo> {
    private static final long serialVersionUID = -3520867380372087997L;
    private String wsId;
    private String storeId;

    public CheckExistingResourcesInWorkspaceValidator(String storeId, String workspaceId) {
        this.storeId = storeId;
        this.wsId = workspaceId;
    }

    public void validate(IValidatable<WorkspaceInfo> validatable) {
        WorkspaceInfo newWorkspace;
        Catalog catalog = GeoServerApplication.get().getCatalog();
        StoreInfo store = catalog.getStore(this.storeId, StoreInfo.class);
        WorkspaceInfo previousWorkspace = catalog.getWorkspace(this.wsId);
        if (previousWorkspace.equals(newWorkspace = (WorkspaceInfo)validatable.getValue())) {
            return;
        }
        NamespaceInfo newNamespace = catalog.getNamespaceByPrefix(newWorkspace.getName());
        List configuredResources = catalog.getResourcesByStore(store, ResourceInfo.class);
        StringBuilder sb = new StringBuilder();
        for (ResourceInfo res : configuredResources) {
            ResourceInfo existing = catalog.getResourceByName(newNamespace, res.getName(), ResourceInfo.class);
            if (existing == null) continue;
            sb.append(existing.getName()).append(" ");
        }
        if (sb.length() > 0) {
            String message = "The following resources already exist on the same namespace: " + sb.toString();
            validatable.error((IValidationError)new ValidationError().setMessage(message));
        }
    }
}

