/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.Repository;
import org.xml.sax.EntityResolver;

public class ParamInfo
implements Serializable {
    private static final long serialVersionUID = 886996604911751174L;
    private final String name;
    private final String title;
    private boolean password;
    private boolean largeText;
    private String level;
    private Class<?> binding;
    private boolean required;
    private boolean deprecated;
    private Serializable value;
    private List<Serializable> options;

    public ParamInfo(DataAccessFactory.Param param) {
        List options;
        Object defaultValue;
        this.name = param.key;
        this.deprecated = param.isDeprecated();
        this.title = param.title != null && !param.title.toString().equals(param.key) ? param.title.toString() : param.getDescription().toString();
        this.password = param.isPassword();
        this.level = param.getLevel();
        this.largeText = param.metadata != null && Boolean.TRUE.equals(param.metadata.get("isLargeText"));
        Object object = defaultValue = this.deprecated ? null : param.sample;
        if (Serializable.class.isAssignableFrom(param.type)) {
            this.binding = param.type;
            this.value = (Serializable)defaultValue;
        } else if (Repository.class.equals((Object)param.type) || EntityResolver.class.isAssignableFrom(param.type)) {
            this.binding = param.type;
            this.value = null;
        } else {
            this.binding = String.class;
            this.value = defaultValue == null ? null : String.valueOf(defaultValue);
        }
        this.required = param.required;
        if (param.metadata != null && (options = (List)param.metadata.get("options")) != null && !options.isEmpty()) {
            this.options = new ArrayList<Serializable>(options);
            if (Comparable.class.isAssignableFrom(this.binding)) {
                Collections.sort(options);
            }
            if (this.value == null) {
                this.value = (Serializable)options.get(0);
            }
        }
    }

    public List<Serializable> getOptions() {
        return this.options;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPassword() {
        return this.password;
    }

    public String getLevel() {
        return this.level;
    }

    public boolean isLargeText() {
        return this.largeText;
    }

    public Class<?> getBinding() {
        return this.binding;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }
}

