/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store.panel;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.model.IModel;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FilePaths;
import org.geoserver.platform.resource.Paths;
import org.geotools.util.logging.Logging;

public class FileModel
implements IModel<String> {
    private static final long serialVersionUID = 3911203737278340528L;
    static final Logger LOGGER = Logging.getLogger(FileModel.class);
    IModel<String> delegate;
    File rootDir;

    public FileModel(IModel<String> delegate) {
        this(delegate, ((GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class)).getBaseDirectory());
    }

    public FileModel(IModel<String> delegate, File rootDir) {
        this.delegate = delegate;
        this.rootDir = rootDir;
    }

    public String getObject() {
        Object obj = this.delegate.getObject();
        if (obj instanceof URL) {
            URL url = (URL)obj;
            return url.toExternalForm();
        }
        return (String)obj;
    }

    public void setObject(String location) {
        if (location != null) {
            String locationPath;
            location = Paths.convert((String)location);
            try {
                locationPath = new URL((String)location).getFile();
            }
            catch (MalformedURLException e) {
                locationPath = location;
            }
            locationPath = Paths.convert((File)this.rootDir, (File)new File(locationPath));
            if (FilePaths.isAbsolute((String)locationPath)) {
                location = "file://" + locationPath;
            } else if (!locationPath.equals(location)) {
                location = "file:" + locationPath;
            }
        }
        this.delegate.setObject(location);
    }

    File canonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not convert " + file + " into canonical form", e);
            return file;
        }
    }
}

