/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.system.status;

import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.web.system.status.ConsoleInfoUtils;

public class JVMConsolePanel
extends Panel {
    private final boolean lockedMonitors = true;
    private final boolean lockedSynchronizers = true;
    private String dumpLog;

    public JVMConsolePanel(String id) {
        super(id);
        this.add(new Component[]{new Link<String>("dumpThread"){
            private static final long serialVersionUID = 9014754243470867547L;

            public void onClick() {
                JVMConsolePanel.this.dumpLog = ConsoleInfoUtils.getThreadsInfo(true, true);
            }
        }});
        this.add(new Component[]{new Link<String>("dumpHeap"){
            private static final long serialVersionUID = 9014754243470867547L;

            public void onClick() {
                JVMConsolePanel.this.dumpLog = ConsoleInfoUtils.getHistoMemoryDump();
            }
        }});
        TextArea logs = new TextArea("dumpContent", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                return JVMConsolePanel.this.dumpLog;
            }
        });
        logs.setOutputMarkupId(true);
        logs.setMarkupId("dumpContent");
        this.add(new Component[]{logs});
        this.add(new Component[]{new Link<String>("downloadlink"){
            private static final long serialVersionUID = 9014754243470867547L;

            public void onClick() {
            }
        }});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)"     function downloadFile(filename) {\n          // It works on all HTML5 Ready browsers as it uses the download attribute of the <a> element:\n          const element = document.createElement('a');\n          //A blob is a data type that can store binary data\n          // \"type\" is a MIME type\n          // It can have a different value, based on a file you want to save\n          const dumpContent = document.getElementById(\"dumpContent\").value;\n          const blob = new Blob([dumpContent], { type: 'plain/text' });\n          //createObjectURL() static method creates a DOMString containing a URL representing the object given in the parameter.\n          const fileUrl = URL.createObjectURL(blob);\n          //setAttribute() Sets the value of an attribute on the specified element.\n          element.setAttribute('href', fileUrl); //file location\n          element.setAttribute('download', filename); // file name\n          element.style.display = 'none';\n          //use appendChild() method to move an element from one element to another\n          document.body.appendChild(element);\n          element.click();\n          //The removeChild() method of the Node interface removes a child node from the DOM and returns the removed node\n          document.body.removeChild(element);\n        };", (String)"downloadFile"));
        response.render((HeaderItem)OnEventHeaderItem.forMarkupId((String)"downloadlink", (String)"click", (CharSequence)"downloadFile('dump.log')"));
    }
}

