/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class HTTPURLsListTextArea
extends TextArea<List<String>> {
    private static final long serialVersionUID = -8195179437229644665L;

    public HTTPURLsListTextArea(String id, IModel<List<String>> model) {
        super(id, model);
        this.add(new HTTPURLsListValidator());
        this.setType(List.class);
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (List.class.isAssignableFrom(type)) {
            return new URLsListConverter();
        }
        return super.getConverter(type);
    }

    private static class HTTPURLsListValidator
    implements IValidator<List<String>> {
        private static final long serialVersionUID = 8041469734553805086L;

        private HTTPURLsListValidator() {
        }

        public void validate(IValidatable<List<String>> validatable) {
            List urlsList = (List)validatable.getValue();
            List invalid = urlsList.stream().filter(url -> !this.isValid((String)url)).collect(Collectors.toList());
            if (!invalid.isEmpty()) {
                ValidationError err = new ValidationError().addKey("HTTPURLsListTextArea.invalidURL").setVariable("url", (Object)invalid.toString());
                validatable.error((IValidationError)err);
            }
        }

        private boolean isValid(String url) {
            boolean isValid = false;
            try {
                URL validURL = new URL(url);
                isValid = validURL.getProtocol().startsWith("http");
            }
            catch (Exception e) {
                isValid = false;
            }
            return isValid;
        }
    }

    private static class URLsListConverter
    implements IConverter<List<String>> {
        private static final long serialVersionUID = 1083795866666107798L;
        static final Pattern NEW_LINE_SEPARATED = Pattern.compile("\\s*\\r?\\n\\s*", 8);

        private URLsListConverter() {
        }

        public String convertToString(List<String> urlsList, Locale locale) {
            if (urlsList.isEmpty()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (String url : urlsList) {
                sb.append(url).append("\n");
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        public List<String> convertToObject(String value, Locale locale) {
            if (value == null || value.trim().equals("")) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(Arrays.asList(NEW_LINE_SEPARATED.split(value)));
        }
    }
}

