/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.model.IModel;

public abstract class LiveCollectionModel<S, T extends Collection<S>>
implements IModel<T> {
    private static final long serialVersionUID = 3505518156788420409L;
    IModel<? extends Collection<S>> wrapped;

    public LiveCollectionModel(IModel<? extends Collection<S>> wrapped) {
        if (wrapped == null) {
            throw new NullPointerException("Live list model cannot wrap a null model");
        }
        this.wrapped = wrapped;
    }

    public void setObject(T object) {
        Collection collection = (Collection)this.wrapped.getObject();
        collection.clear();
        if (object != null) {
            collection.addAll(object);
        }
    }

    public void detach() {
        this.wrapped.detach();
    }

    public static <S> LiveCollectionModel<S, List<S>> list(IModel<? extends Collection<S>> wrapped) {
        return new LiveCollectionModel<S, List<S>>((IModel)wrapped){
            private static final long serialVersionUID = 3182237972594668864L;

            public List<S> getObject() {
                return new ArrayList((Collection)this.wrapped.getObject());
            }
        };
    }

    public static <S> LiveCollectionModel<S, Set<S>> set(IModel<? extends Collection<S>> wrapped) {
        return new LiveCollectionModel<S, Set<S>>((IModel)wrapped){
            private static final long serialVersionUID = 7638792616781214296L;

            public Set<S> getObject() {
                return new HashSet((Collection)this.wrapped.getObject());
            }
        };
    }
}

