/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxFallbackLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class FileBreadcrumbs
extends Panel {
    private static final long serialVersionUID = 2821319341957784628L;
    IModel<File> rootFile;

    public FileBreadcrumbs(String id, IModel<File> rootFile, IModel<File> currentFile) {
        super(id, currentFile);
        this.rootFile = rootFile;
        this.add(new Component[]{new ListView<File>("path", (IModel)new BreadcrumbModel(rootFile, currentFile)){
            private static final long serialVersionUID = -855582301247703291L;

            protected void populateItem(ListItem<File> item) {
                File file = (File)item.getModelObject();
                boolean last = item.getIndex() == this.getList().size() - 1;
                Label name = new Label("pathItem", (Serializable)((Object)(file.getName() + "/")));
                IndicatingAjaxFallbackLink<File> link = new IndicatingAjaxFallbackLink<File>("pathItemLink", item.getModel()){
                    private static final long serialVersionUID = 4295991386838610752L;

                    public void onClick(Optional<AjaxRequestTarget> target) {
                        FileBreadcrumbs.this.pathItemClicked((File)this.getModelObject(), target);
                    }
                };
                link.add(new Component[]{name});
                item.add(new Component[]{link});
                link.setEnabled(!last);
            }
        }});
    }

    public void setRootFile(File root) {
        this.rootFile.setObject((Object)root);
    }

    public void setSelection(File selection) {
        this.setDefaultModelObject(selection);
    }

    protected abstract void pathItemClicked(File var1, Optional<AjaxRequestTarget> var2);

    static class BreadcrumbModel
    implements IModel<List<File>> {
        private static final long serialVersionUID = -3497123851146725406L;
        IModel<File> rootFileModel;
        IModel<File> currentFileModel;

        public BreadcrumbModel(IModel<File> rootFileModel, IModel<File> currentFileModel) {
            this.rootFileModel = rootFileModel;
            this.currentFileModel = currentFileModel;
        }

        public List<File> getObject() {
            File current;
            File root = (File)this.rootFileModel.getObject();
            ArrayList<File> files = new ArrayList<File>();
            for (current = (File)this.currentFileModel.getObject(); current != null && !current.equals(root); current = current.getParentFile()) {
                files.add(current);
            }
            if (current != null && current.equals(root)) {
                files.add(root);
            }
            Collections.reverse(files);
            return files;
        }

        public void setObject(List<File> object) {
            throw new UnsupportedOperationException("This model cannot be set!");
        }
    }
}

