/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxFallbackLink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.web.wicket.browser.FileProvider;

public abstract class FileDataView
extends Panel {
    private static final IConverter<File> FILE_NAME_CONVERTER = new StringConverter(){

        public String convertToString(File file, Locale locale) {
            if (file.isDirectory()) {
                return file.getName() + "/";
            }
            return file.getName();
        }
    };
    private static final IConverter<File> FILE_LASTMODIFIED_CONVERTER = new StringConverter(){

        public String convertToString(File file, Locale locale) {
            long lastModified = file.lastModified();
            if (lastModified == 0L) {
                return null;
            }
            return DateFormat.getDateTimeInstance(2, 3).format(new Date(file.lastModified()));
        }
    };
    private static final IConverter<File> FILE_SIZE_CONVERTER = new StringConverter(){
        private static final double KBYTE = 1024.0;
        private static final double MBYTE = 1048576.0;
        private static final double GBYTE = 1.073741824E9;

        public String convertToString(File value, Locale locale) {
            File file = value;
            if (!file.isFile()) {
                return "";
            }
            long size = file.length();
            if (size == 0L) {
                return null;
            }
            if ((double)size < 1024.0) {
                return "" + size;
            }
            if ((double)size < 1048576.0) {
                return new DecimalFormat("#.#").format((double)size / 1024.0) + "K";
            }
            if ((double)size < 1.073741824E9) {
                return new DecimalFormat("#.#").format((double)size / 1048576.0) + "M";
            }
            return new DecimalFormat("#.#").format((double)size / 1.073741824E9) + "G";
        }
    };
    FileProvider provider;
    WebMarkupContainer fileContent;
    String tableHeight = "25em";

    public FileDataView(String id, FileProvider fileProvider) {
        super(id);
        this.provider = fileProvider;
        WebMarkupContainer table = new WebMarkupContainer("fileTable");
        table.setOutputMarkupId(true);
        this.add(new Component[]{table});
        DataView<File> fileTable = new DataView<File>("files", (IDataProvider)fileProvider){

            protected void populateItem(final Item<File> item) {
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(item.getIndex() % 2 == 0 ? "even" : "odd")))});
                IndicatingAjaxFallbackLink<Void> link = new IndicatingAjaxFallbackLink<Void>("nameLink"){

                    public void onClick(Optional<AjaxRequestTarget> target) {
                        FileDataView.this.linkNameClicked((File)item.getModelObject(), target);
                    }
                };
                link.add(new Component[]{new Label("name", item.getModel()){

                    public <C> IConverter<C> getConverter(Class<C> type) {
                        return FILE_NAME_CONVERTER;
                    }
                }});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("lastModified", item.getModel()){

                    public <C> IConverter<C> getConverter(Class<C> type) {
                        return FILE_LASTMODIFIED_CONVERTER;
                    }
                }});
                item.add(new Component[]{new Label("size", item.getModel()){

                    public <C> IConverter<C> getConverter(Class<C> type) {
                        return FILE_SIZE_CONVERTER;
                    }
                }});
            }
        };
        this.fileContent = new WebMarkupContainer("fileContent");
        if (this.tableHeight != null) {
            this.fileContent.setOutputMarkupId(true);
            this.fileContent.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"overflowAuto"))});
            this.fileContent.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 4820788798632906484L;

                public void renderHead(Component component, IHeaderResponse response) {
                    String script = "document.getElementById('" + FileDataView.this.fileContent.getMarkupId() + "').style.height = '" + StringEscapeUtils.escapeEcmaScript((String)FileDataView.this.tableHeight) + "';";
                    response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)script));
                }
            }});
        }
        this.fileContent.add(new Component[]{fileTable});
        table.add(new Component[]{this.fileContent});
        table.add(new Component[]{new OrderByBorder("nameHeader", (Object)"name", (ISortStateLocator)fileProvider)});
        table.add(new Component[]{new OrderByBorder("lastModifiedHeader", (Object)"lastModified", (ISortStateLocator)fileProvider)});
        table.add(new Component[]{new OrderByBorder("sizeHeader", (Object)"size", (ISortStateLocator)fileProvider)});
    }

    protected abstract void linkNameClicked(File var1, Optional<AjaxRequestTarget> var2);

    public FileProvider getProvider() {
        return this.provider;
    }

    public void setTableHeight(String tableHeight) {
        this.tableHeight = tableHeight;
    }

    private static abstract class StringConverter
    implements IConverter<File> {
        private StringConverter() {
        }

        public File convertToObject(String value, Locale locale) {
            throw new UnsupportedOperationException("This converter works only for strings");
        }
    }
}

