/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.Arrays;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebPage;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.Service;
import org.geoserver.web.CapabilitiesHomePagePanel;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.ServiceInfoCapabilitiesProvider;
import org.geotools.util.Version;
import org.junit.Assert;
import org.junit.Test;

public class CapabilitiesHomePagePanelTest
extends GeoServerWicketTestSupport {
    @Test
    public void testCapabilitiesLinks() {
        CapabilitiesHomePagePanel.CapsInfo ci1 = new CapabilitiesHomePagePanel.CapsInfo("FakeService1", new Version("1.0.0"), "../caps1_v1");
        CapabilitiesHomePagePanel.CapsInfo ci2 = new CapabilitiesHomePagePanel.CapsInfo("FakeService1", new Version("1.1.0"), "../caps1_v2");
        CapabilitiesHomePagePanel.CapsInfo ci3 = new CapabilitiesHomePagePanel.CapsInfo("FakeService2", new Version("1.1.0"), "../caps2");
        CapabilitiesHomePagePanel panel = new CapabilitiesHomePagePanel("capsList", Arrays.asList(ci1, ci2, ci3));
        TestPage page = new TestPage();
        page.add(new Component[]{panel});
        tester.startPage((Page)page);
        tester.assertLabel("capsList:services:0:link:service", "FakeService1");
        tester.assertLabel("capsList:services:1:link:service", "FakeService1");
        tester.assertLabel("capsList:services:2:link:service", "FakeService2");
        tester.assertLabel("capsList:services:0:link:version", "1.1.0");
        tester.assertLabel("capsList:services:1:link:version", "1.0.0");
        tester.assertLabel("capsList:services:2:link:version", "1.1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCapabilitiesLinksSkipped() {
        Service fakeService1 = new Service("Fake", new Object(), new Version("1.0.0"), Arrays.asList("GetCapabilities"));
        Service fakeService2 = new Service("Fake2", new Object(), new Version("1.0.0"), Arrays.asList("GetCapabilities"));
        try {
            GeoServerExtensionsHelper.singleton((String)"fake1", (Object)fakeService1, (Class[])new Class[0]);
            GeoServerExtensionsHelper.singleton((String)"fake2", (Object)fakeService2, (Class[])new Class[0]);
            ServiceInfoCapabilitiesProvider provider = new ServiceInfoCapabilitiesProvider();
            Set skip = provider.skipServiceDescriptionProviders();
            Assert.assertTrue((boolean)skip.contains("fake"));
            CapabilitiesHomePagePanel panel = (CapabilitiesHomePagePanel)provider.getCapabilitiesComponent("capsList");
            TestPage page = new TestPage();
            page.add(new Component[]{panel});
            tester.startPage((Page)page);
            tester.assertLabel("capsList:services:0:link:service", "Fake2");
            tester.assertLabel("capsList:services:0:link:version", "1.0.0");
        }
        finally {
            GeoServerExtensionsHelper.clear();
        }
    }

    public static class TestPage
    extends WebPage {
        private static final long serialVersionUID = -4374237095130771859L;
    }
}

