/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

public class GeoServerConsoleFlagTest
extends GeoServerSystemTestSupport {
    private static final String CONSOLE_DISABLED_PUBLISHER = "filePublisher";
    private static final String CONSOLE_ENABLED_PUBLISHER = "wicket";
    private static final String WEB_MAPPING = "/web";
    private static final String WEB_WILDCARD_MAPPING = "/web/**";
    private static final String WEB_RESOURCES_WILDCARD_MAPPING = "/web/resources/**";

    private void setGeoserverConsoleDisabled(boolean disabled) {
        System.setProperty("GEOSERVER_CONSOLE_DISABLED", Boolean.toString(disabled));
    }

    private SimpleUrlHandlerMapping getWebDispatcherMapping(boolean disabled) throws Exception {
        this.setGeoserverConsoleDisabled(disabled);
        this.tearDown((SystemTestData)this.getTestData());
        this.setUp((SystemTestData)this.getTestData());
        return (SimpleUrlHandlerMapping)applicationContext.getBean("webDispatcherMapping");
    }

    @Test
    public void testGeoServerConsoleDisabledTrue() throws Exception {
        SimpleUrlHandlerMapping mapping = this.getWebDispatcherMapping(true);
        Assert.assertEquals(mapping.getUrlMap().get(WEB_MAPPING), (Object)CONSOLE_DISABLED_PUBLISHER);
        Assert.assertEquals(mapping.getUrlMap().get(WEB_WILDCARD_MAPPING), (Object)CONSOLE_DISABLED_PUBLISHER);
        Assert.assertEquals(mapping.getUrlMap().get(WEB_RESOURCES_WILDCARD_MAPPING), (Object)CONSOLE_DISABLED_PUBLISHER);
    }

    @Test
    public void testGeoserverConsoleDisabledFalse() throws Exception {
        SimpleUrlHandlerMapping mapping = this.getWebDispatcherMapping(false);
        Assert.assertEquals(mapping.getUrlMap().get(WEB_MAPPING), (Object)CONSOLE_ENABLED_PUBLISHER);
        Assert.assertEquals(mapping.getUrlMap().get(WEB_WILDCARD_MAPPING), (Object)CONSOLE_ENABLED_PUBLISHER);
        Assert.assertEquals(mapping.getUrlMap().get(WEB_RESOURCES_WILDCARD_MAPPING), (Object)CONSOLE_ENABLED_PUBLISHER);
    }

    @After
    public void cleanup() throws Exception {
        this.setGeoserverConsoleDisabled(false);
        this.tearDown((SystemTestData)this.getTestData());
    }
}

