/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;

public class GeoServerWicketOnlineTestSupport {
    protected static final String GEOSERVER_BASE_URL = "http://localhost:9090/geoserver";

    protected boolean isOnline() {
        try {
            URL u = new URL(GEOSERVER_BASE_URL);
            HttpURLConnection huc = (HttpURLConnection)u.openConnection();
            huc.setRequestMethod("HEAD");
            huc.connect();
            return huc.getResponseCode() == 200;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void logout(String jsessionid) throws IOException {
        this.post("j_spring_security_logout", "", "application/x-www-form-urlencoded", jsessionid).disconnect();
    }

    public String login(String username, String password) throws IOException {
        HttpURLConnection huc = this.get("web/", null);
        String cookie = huc.getHeaderField("Set-Cookie");
        String jsessionid = this.parseJsessionid(cookie);
        huc.disconnect();
        String body = "username=" + username + "&password=" + password;
        huc = this.preparePost("j_spring_security_check", body.length(), "application/x-www-form-urlencoded", jsessionid);
        huc.setInstanceFollowRedirects(false);
        huc = this.doPost(huc, body);
        while (huc.getResponseCode() == 302) {
            String location;
            if (huc.getHeaderField("Set-Cookie") != null) {
                cookie = huc.getHeaderField("Set-Cookie");
                jsessionid = this.parseJsessionid(cookie);
            }
            if ((location = huc.getHeaderField("Location")).startsWith(GEOSERVER_BASE_URL)) {
                location = location.substring(GEOSERVER_BASE_URL.length() + 1);
            }
            huc.disconnect();
            huc = this.prepareGet(location, jsessionid, null);
            huc.setInstanceFollowRedirects(false);
            huc = this.doGet(huc);
        }
        String homePage = IOUtils.toString((InputStream)huc.getInputStream(), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)homePage.contains("Logged in as <span>" + username + "</span>"));
        huc.disconnect();
        return jsessionid;
    }

    private String parseJsessionid(String cookie) {
        String[] parts;
        String jsessionid = null;
        for (String part : parts = cookie.split(";")) {
            if (!part.startsWith("JSESSIONID=")) continue;
            jsessionid = part;
        }
        return jsessionid;
    }

    protected HttpURLConnection get(String url, String jsessionid) throws IOException {
        return this.get(url, jsessionid, null);
    }

    protected HttpURLConnection get(String url, String jsessionid, String accept) throws IOException {
        return this.doGet(this.prepareGet(url, jsessionid, accept));
    }

    protected HttpURLConnection prepareGet(String url, String jsessionid, String accept) throws IOException {
        URL u = new URL("http://localhost:9090/geoserver/" + url);
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        if (accept != null) {
            huc.setRequestProperty("Accept", accept);
        }
        huc.setRequestMethod("GET");
        if (jsessionid != null) {
            huc.setRequestProperty("Cookie", jsessionid);
            huc.setRequestProperty("Host", "localhost:8080");
            huc.setRequestProperty("Upgrade-Insecure-Requests", "1");
        }
        return huc;
    }

    protected HttpURLConnection doGet(HttpURLConnection huc) throws IOException {
        huc.connect();
        return huc;
    }

    protected HttpURLConnection post(String url, String body, String contentType, String jsessionid) throws IOException {
        return this.doPost(this.preparePost(url, body.length(), contentType, jsessionid), body);
    }

    protected HttpURLConnection preparePost(String url, int contentLength, String contentType, String jsessionid) throws IOException {
        URL u = new URL("http://localhost:9090/geoserver/" + url);
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        huc.setRequestMethod("POST");
        huc.setRequestProperty("Content-Type", contentType);
        huc.setRequestProperty("Content-Length", String.valueOf(contentLength));
        if (jsessionid != null) {
            huc.setRequestProperty("Cookie", jsessionid);
            huc.setRequestProperty("Host", "localhost:8080");
            huc.setRequestProperty("Origin", "http://localhost:8080");
            huc.setRequestProperty("Connection", "keep-alive");
            huc.setRequestProperty("Upgrade-Insecure-Requests", "1");
        }
        huc.setDoOutput(true);
        return huc;
    }

    protected HttpURLConnection doPost(HttpURLConnection huc, String body) throws IOException {
        huc.connect();
        try (PrintWriter out = new PrintWriter(huc.getOutputStream());){
            out.print(body);
        }
        return huc;
    }

    protected HttpURLConnection delete(String url, String jsessionid) throws IOException {
        return this.doGet(this.prepareDelete(url, jsessionid));
    }

    protected HttpURLConnection prepareDelete(String url, String jsessionid) throws IOException {
        URL u = new URL("http://localhost:9090/geoserver/" + url);
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        huc.setRequestMethod("DELETE");
        if (jsessionid != null) {
            huc.setRequestProperty("Cookie", jsessionid);
            huc.setRequestProperty("Host", "localhost:8080");
            huc.setRequestProperty("Upgrade-Insecure-Requests", "1");
        }
        return huc;
    }
}

