/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.tester.WicketTester;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerResourceStreamLocator;
import org.geoserver.web.GeoServerStringResourceLoader;
import org.geoserver.web.wicket.WicketHierarchyPrinter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class GeoServerWicketTestSupport
extends GeoServerSecurityTestSupport {
    public static WicketTester tester;

    @BeforeClass
    public static void disableBrowserDetection() {
        GeoServerApplication.DETECT_BROWSER = false;
    }

    @AfterClass
    public static void cleanupWicketConfiguration() throws Exception {
        System.clearProperty("wicket.configuration");
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        System.setProperty("wicket.configuration", this.getWicketConfiguration().name());
        System.setProperty("GEOSERVER_CSRF_DISABLED", "true");
        Locale.setDefault(Locale.ENGLISH);
        GeoServerApplication app = (GeoServerApplication)applicationContext.getBean("webApplication");
        tester = new WicketTester((WebApplication)app, false);
        app.init();
    }

    protected RuntimeConfigurationType getWicketConfiguration() {
        return RuntimeConfigurationType.DEPLOYMENT;
    }

    @After
    public void clearErrorMessages() {
        if (tester != null && !tester.getFeedbackMessages(IFeedbackMessageFilter.ALL).isEmpty()) {
            tester.cleanupFeedbackMessages();
        }
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        super.onTearDown(testData);
        tester.destroy();
    }

    public GeoServerApplication getGeoServerApplication() {
        return GeoServerApplication.get();
    }

    public void login() {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
    }

    public void logout() {
        this.login("anonymousUser", "", new String[]{"ROLE_ANONYMOUS"});
    }

    public void print(Component c, boolean dumpClass, boolean dumpValue) {
        if (GeoServerWicketTestSupport.isQuietTests()) {
            return;
        }
        WicketHierarchyPrinter.print((Component)c, (boolean)dumpClass, (boolean)dumpValue);
    }

    public void print(Component c, boolean dumpClass, boolean dumpValue, boolean dumpPath) {
        if (GeoServerWicketTestSupport.isQuietTests()) {
            return;
        }
        WicketHierarchyPrinter.print((Component)c, (boolean)dumpClass, (boolean)dumpValue);
    }

    public Component findComponentByContent(MarkupContainer root, Object content, Class<?> componentClass) {
        ComponentContentFinder finder = new ComponentContentFinder(content);
        root.visitChildren(componentClass, (IVisitor)finder);
        return finder.candidate;
    }

    protected String getComponentPath(WebMarkupContainer container, Class<? extends Component> targetClass) {
        AtomicReference result = new AtomicReference();
        container.visitChildren((component, visit) -> {
            if (targetClass.isInstance(component)) {
                result.set(component.getPageRelativePath());
                visit.stop();
            }
        });
        return (String)result.get();
    }

    protected String getNthComponentPath(WebMarkupContainer container, Class<? extends Component> targetClass, int n) {
        ArrayList results = new ArrayList();
        container.visitChildren((component, visit) -> {
            if (targetClass.isInstance(component)) {
                results.add(component.getPageRelativePath());
            }
        });
        return (String)results.get(n);
    }

    public static void initResourceSettings(WicketTester tester) {
        tester.getApplication().getResourceSettings().setResourceStreamLocator((IResourceStreamLocator)new GeoServerResourceStreamLocator());
        tester.getApplication().getResourceSettings().getStringResourceLoaders().add(0, new GeoServerStringResourceLoader());
    }

    protected AjaxEventBehavior getAjaxBehavior(String path, String event) {
        for (Behavior b : tester.getComponentFromLastRenderedPage(path).getBehaviors()) {
            if (!(b instanceof AjaxEventBehavior) || !((AjaxEventBehavior)b).getEvent().equals(event)) continue;
            return (AjaxEventBehavior)b;
        }
        return null;
    }

    protected void executeExactAjaxEventBehavior(String path, String event, String value) {
        tester.getRequest().setParameter(path, value);
        tester.getRequest().setMethod("GET");
        tester.executeAjaxEvent(path, event);
    }

    protected void executeAjaxEventBehavior(String path, String event, String value) {
        String[] ids = path.split(":");
        String id = ids[ids.length - 1];
        tester.getRequest().setParameter(id, value);
        tester.getRequest().setMethod("GET");
        tester.executeAjaxEvent(path, event);
    }

    protected void setFormComponentValue(FormComponent component, String value) {
        tester.getRequest().getPostParameters().setParameterValue(component.getInputName(), value);
    }

    class ComponentContentFinder
    implements IVisitor<Component, Void> {
        Component candidate;
        Object content;

        ComponentContentFinder(Object content) {
            this.content = content;
        }

        public void component(Component component, IVisit<Void> visit) {
            if (this.content.equals(component.getDefaultModelObject())) {
                this.candidate = component;
                visit.stop();
            }
        }
    }
}

