/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import org.apache.wicket.Component;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.CoverageAccessPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoverageAccessPageTest
extends GeoServerWicketTestSupport {
    private GeoServer geoServer;

    @Before
    public void reset() {
        this.geoServer = this.getGeoServerApplication().getGeoServer();
        GeoServerInfo gsInfo = this.geoServer.getGlobal();
        CoverageAccessInfo cai = gsInfo.getCoverageAccess();
        cai.setCorePoolSize(2);
        this.geoServer.save(gsInfo);
    }

    @Test
    public void testLoad() throws Exception {
        this.login();
        tester.startPage(CoverageAccessPage.class);
        tester.assertRenderedPage(CoverageAccessPage.class);
    }

    @Test
    public void testSave() throws Exception {
        this.login();
        tester.startPage(CoverageAccessPage.class);
        this.print((Component)tester.getLastRenderedPage(), true, true);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("corePoolSize", "3");
        ft.submit("submit");
        tester.assertRenderedPage(GeoServerHomePage.class);
        CoverageAccessInfo cai = this.geoServer.getGlobal().getCoverageAccess();
        Assert.assertEquals((long)3L, (long)cai.getCorePoolSize());
    }

    @Test
    public void testApply() throws Exception {
        this.login();
        tester.startPage(CoverageAccessPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("corePoolSize", "5");
        ft.submit("apply");
        tester.assertRenderedPage(CoverageAccessPage.class);
        CoverageAccessInfo cai = this.geoServer.getGlobal().getCoverageAccess();
        Assert.assertEquals((long)5L, (long)cai.getCorePoolSize());
    }
}

