/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.File;
import org.geoserver.config.GeoServer;
import org.geoserver.config.LoggingInfo;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.LogPage;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Test;

public class LogPageTest
extends GeoServerWicketTestSupport {
    protected static File logsDir = null;

    @AfterClass
    public static void cleanupLogs() {
        if (logsDir != null) {
            Files.delete((File)logsDir);
            logsDir = null;
        }
    }

    @After
    public void after() {
        Resource logs = this.getDataDirectory().get(new String[]{"logs"});
        if (logs.getType() == Resource.Type.DIRECTORY) {
            logsDir = logs.dir();
        }
    }

    @Test
    public void testDefaultLocation() {
        GeoServer gs = this.getGeoServerApplication().getGeoServer();
        LoggingInfo logging = gs.getLogging();
        logging.setLocation("logs/geoserver.log");
        gs.save(logging);
        this.login();
        tester.startPage(LogPage.class);
        tester.assertRenderedPage(LogPage.class);
    }

    @Test
    public void testNullLocation() {
        GeoServer gs = this.getGeoServerApplication().getGeoServer();
        LoggingInfo logging = gs.getLogging();
        logging.setLocation(null);
        gs.save(logging);
        this.login();
        tester.startPage(LogPage.class);
        tester.assertRenderedPage(LogPage.class);
    }
}

