/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.ModuleStatus;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.AbstractStatusPage;
import org.geoserver.web.admin.ExtraTabPanel;
import org.geoserver.web.admin.StatusPage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;

public class StatusPageTest
extends GeoServerWicketTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void setupTests() {
        this.login();
        tester.startPage(StatusPage.class);
    }

    @Test
    public void testValues() {
        tester.assertRenderedPage(StatusPage.class);
        tester.assertLabel("tabs:panel:locks", "0");
        tester.assertLabel("tabs:panel:jai.memory.used", "0 KB");
        Label resourceCache = (Label)tester.getComponentFromLastRenderedPage("tabs:panel:resourceCache");
        Assert.assertNotEquals((Object)"0", (Object)resourceCache.getDefaultModelObjectAsString());
    }

    @Test
    public void testFreeLocks() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:panel:free.locks", false);
        tester.assertRenderedPage(StatusPage.class);
    }

    @Test
    public void testFreeMemory() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:panel:free.memory", false);
        tester.assertRenderedPage(StatusPage.class);
    }

    @Test
    public void testFreeMemoryJAI() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:panel:free.memory.jai", false);
        tester.assertRenderedPage(StatusPage.class);
    }

    @Test
    public void testClearCache() throws IOException {
        tester.assertRenderedPage(StatusPage.class);
        this.getCatalog().getResourcePool().getCRS("EPSG:900913");
        tester.clickLink("tabs:panel:free.memory.jai", false);
        tester.assertRenderedPage(StatusPage.class);
        Label resourceCache = (Label)tester.getComponentFromLastRenderedPage("tabs:panel:resourceCache");
        int before = Integer.valueOf(resourceCache.getDefaultModelObjectAsString());
        tester.clickLink("tabs:panel:clear.resourceCache", true);
        tester.assertRenderedPage(StatusPage.class);
        resourceCache = (Label)tester.getComponentFromLastRenderedPage("tabs:panel:resourceCache");
        int after = Integer.valueOf(resourceCache.getDefaultModelObjectAsString());
        Assert.assertTrue((String)"cleared", (before > after ? 1 : 0) != 0);
    }

    @Test
    public void testReloadConfig() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:panel:reload.catalogConfig", true);
        tester.assertRenderedPage(StatusPage.class);
    }

    @Test
    public void testReload() throws Exception {
        tester.assertRenderedPage(StatusPage.class);
        this.getGeoServer().reload();
        this.login();
        tester.startPage(StatusPage.class);
        tester.assertRenderedPage(StatusPage.class);
    }

    @Test
    public void testModuleStatusPanel() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:1:link", true);
        tester.assertContains("gs-main");
    }

    @Test
    public void testModuleStatusPanelOrder() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:1:link", true);
        tester.assertContains("gs-main");
        Component component = tester.getComponentFromLastRenderedPage("tabs:panel:listViewContainer:modules");
        MatcherAssert.assertThat((Object)component, (Matcher)CoreMatchers.instanceOf(ListView.class));
        List modules = ((ListView)component).getList().stream().map(ModuleStatus::getModule).collect(Collectors.toList());
        MatcherAssert.assertThat(modules, (Matcher)CoreMatchers.hasItem((Object)"gs-main"));
        MatcherAssert.assertThat(modules, (Matcher)CoreMatchers.hasItem((Object)"gs-web-core"));
        MatcherAssert.assertThat(modules, (Matcher)CoreMatchers.hasItem((Object)"jvm"));
        List sorted = modules.stream().sorted().collect(Collectors.toList());
        Assert.assertEquals(sorted, modules);
    }

    @Test
    public void testModuleStatusPanelVersion() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:1:link", true);
        tester.assertContains("jvm");
        ListView modules = (ListView)tester.getComponentFromLastRenderedPage("tabs:panel:listViewContainer:modules");
        int index = 0;
        int found = -1;
        for (ModuleStatus item : modules.getList()) {
            if (item.getModule().equals("jvm")) {
                Assert.assertEquals((Object)System.getProperty("java.version"), item.getVersion().get());
                found = index;
            }
            ++index;
        }
        if (found == -1) {
            Assert.fail((String)"Module jvm not found, required for version check");
        }
        Component version = tester.getComponentFromLastRenderedPage("tabs:panel:listViewContainer:modules:" + found + ":version");
        Assert.assertTrue((boolean)(version instanceof Label));
        Assert.assertNotNull((Object)version.getDefaultModelObjectAsString());
        Assert.assertEquals((Object)System.getProperty("java.version"), (Object)version.getDefaultModelObjectAsString().trim());
    }

    @Test
    public void testModuleStatusPopup() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:1:link", true);
        tester.clickLink("tabs:panel:listViewContainer:modules:0:msg", true);
        tester.assertRenderedPage(StatusPage.class);
        tester.assertContains("GeoServer Main");
        tester.assertContains("gs-main");
        tester.assertContains("Message:");
    }

    @Test
    public void testExtraTabExists() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:4:link", true);
        tester.assertRenderedPage(StatusPage.class);
        tester.assertContains("extra tab content");
        Component component = tester.getComponentFromLastRenderedPage("tabs:tabs-container:tabs:4:link:title");
        MatcherAssert.assertThat((Object)component, (Matcher)CoreMatchers.instanceOf(Label.class));
        Label label = (Label)component;
        MatcherAssert.assertThat((Object)label.getDefaultModel(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)label.getDefaultModel().getObject(), (Matcher)CoreMatchers.is((Object)"extra"));
    }

    @Test
    public void redirectUnauthorizedToLogin() throws Exception {
        this.logout();
        MockHttpServletResponse response = this.getAsServletResponse("web/wicket/bookmarkable/org.geoserver.web.admin.StatusPage?29-1.ILinkListener-tabs-tabs~container-tabs-1-link");
        Assert.assertEquals((long)HttpStatus.FOUND.value(), (long)response.getStatus());
        Assert.assertEquals((Object)"./org.geoserver.web.GeoServerLoginPage", (Object)response.getHeader("Location"));
    }

    @Test
    public void testTabSwitch() {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:2:link", true);
        tester.assertRenderedPage(StatusPage.class);
        tester.assertContains("CPUs");
        tester.clickLink("tabs:tabs-container:tabs:1:link", true);
        tester.assertRenderedPage(StatusPage.class);
        tester.assertContains("gs-main");
    }

    public static final class ExtraTabDefinition
    implements AbstractStatusPage.TabDefinition,
    Serializable {
        public String getTitleKey() {
            return "StatusPageTest.extra";
        }

        public Panel createPanel(String panelId, Page containerPage) {
            return new ExtraTabPanel(panelId);
        }
    }
}

