/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data;

import java.util.List;
import org.apache.wicket.Page;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.ConfirmRemovalPanel;
import org.junit.Assert;
import org.junit.Test;

public class ConfirmRemovalPanelTest
extends GeoServerWicketTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle(catalog.getWorkspaceByName(MockData.CITE_PREFIX), "lakes", "Lakes.sld", SystemTestData.class, catalog);
    }

    void setupPanel(CatalogInfo ... roots) {
        tester.startPage((Page)new FormTestPage(id -> new ConfirmRemovalPanel(id, roots)));
    }

    @Test
    public void testRemoveWorkspace() {
        this.setupPanel(new CatalogInfo[]{this.getCatalog().getWorkspaceByName(MockData.CITE_PREFIX)});
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertNoErrorMessage();
        tester.assertLabel("form:panel:removedObjects:storesRemoved:stores", "cite");
        tester.assertLabel("form:panel:removedObjects:stylesRemoved:styles", "lakes");
        String layers = tester.getComponentFromLastRenderedPage("form:panel:removedObjects:layersRemoved:layers").getDefaultModelObjectAsString();
        String[] layerArray = layers.split(", ");
        DataStoreInfo citeStore = (DataStoreInfo)this.getCatalog().getStoreByName("cite", DataStoreInfo.class);
        List typeInfos = this.getCatalog().getResourcesByStore((StoreInfo)citeStore, FeatureTypeInfo.class);
        Assert.assertEquals((long)typeInfos.size(), (long)layerArray.length);
    }

    @Test
    public void testRemoveLayer() {
        this.setupPanel(new CatalogInfo[]{this.getCatalog().getLayerByName(this.getLayerId(MockData.BUILDINGS))});
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertNoErrorMessage();
        Assert.assertFalse((boolean)tester.getLastRenderedPage().get("form:panel:removedObjects:storesRemoved").isVisible());
        Assert.assertFalse((boolean)tester.getLastRenderedPage().get("form:panel:modifiedObjects").isVisible());
    }

    @Test
    public void testRemoveStyle() {
        this.setupPanel(new CatalogInfo[]{this.getCatalog().getStyleByName(MockData.BUILDINGS.getLocalPart())});
        tester.assertRenderedPage(FormTestPage.class);
        tester.assertNoErrorMessage();
        Assert.assertFalse((boolean)tester.getLastRenderedPage().get("form:panel:removedObjects:storesRemoved").isVisible());
        tester.assertLabel("form:panel:modifiedObjects:layersModified:layers", "Buildings");
    }
}

