/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.wicket.Page;
import org.apache.wicket.request.mapper.parameter.INamedParameters;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.layer.LayerProvider;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.junit.Assert;
import org.junit.Test;

public class LayerPageTest
extends GeoServerWicketTestSupport {
    public static QName GS_BUILDINGS = new QName(MockData.DEFAULT_URI, "Buildings", MockData.DEFAULT_PREFIX);

    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(CiteTestData.BUILDINGS, this.getCatalog());
        HashMap<SystemTestData.LayerProperty, String> props = new HashMap<SystemTestData.LayerProperty, String>();
        props.put(SystemTestData.LayerProperty.STYLE, CiteTestData.BUILDINGS.getLocalPart());
        testData.addVectorLayer(GS_BUILDINGS, props, this.getCatalog());
    }

    @Test
    public void testBasicActions() {
        this.login();
        tester.startPage((Page)new LayerPage());
        tester.assertRenderedPage(LayerPage.class);
        tester.assertNoErrorMessage();
        GeoServerTablePanel table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        Assert.assertEquals((long)2L, (long)table.getDataProvider().size());
        List<String> workspaces = this.getWorkspaces(table);
        Assert.assertTrue((boolean)workspaces.contains("cite"));
        Assert.assertTrue((boolean)workspaces.contains("gs"));
        String wsSortPath = "table:listContainer:sortableLinks:3:header:link";
        tester.clickLink(wsSortPath, true);
        workspaces = this.getWorkspaces(table);
        Assert.assertEquals((Object)"cite", (Object)workspaces.get(0));
        Assert.assertEquals((Object)"gs", (Object)workspaces.get(1));
        tester.clickLink(wsSortPath, true);
        workspaces = this.getWorkspaces(table);
        Assert.assertEquals((Object)"gs", (Object)workspaces.get(0));
        Assert.assertEquals((Object)"cite", (Object)workspaces.get(1));
        table.selectIndex(1);
        Assert.assertEquals((long)1L, (long)table.getSelection().size());
        LayerInfo li = (LayerInfo)table.getSelection().get(0);
        Assert.assertEquals((Object)"cite", (Object)li.getResource().getStore().getWorkspace().getName());
    }

    @Test
    public void testFilterState() {
        this.login();
        tester.startPage((Page)new LayerPage());
        tester.assertRenderedPage(LayerPage.class);
        tester.assertNoErrorMessage();
        GeoServerTablePanel table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        Assert.assertEquals((long)2L, (long)table.getDataProvider().size());
        List<String> workspaces = this.getWorkspaces(table);
        Assert.assertTrue((boolean)workspaces.contains("cite"));
        Assert.assertTrue((boolean)workspaces.contains("gs"));
        FormTester ft = tester.newFormTester("table:filterForm");
        ft.setValue("filter", "cite");
        ft.submit("submit");
        tester.assertVisible("table:filterForm:clear");
        table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        Assert.assertEquals((long)1L, (long)table.getDataProvider().size());
        LayerInfo layerInfo = (LayerInfo)this.getCatalog().getLayers().get(0);
        tester.startPage((Page)new ResourceConfigurationPage(layerInfo, false));
        tester.assertRenderedPage(ResourceConfigurationPage.class);
        tester.assertNoErrorMessage();
        ft = tester.newFormTester("publishedinfo");
        ft.submit("save");
        tester.assertRenderedPage(LayerPage.class);
        tester.assertVisible("table:filterForm:clear");
        tester.assertModelValue("table:filterForm:filter", (Object)"cite");
        table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        Assert.assertEquals((long)1L, (long)table.getDataProvider().size());
        tester.clickLink("table:filterForm:clear", true);
        tester.assertInvisible("table:filterForm:clear");
        tester.assertModelValue("table:filterForm:filter", (Object)"");
        table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        Assert.assertEquals((long)2L, (long)table.getDataProvider().size());
    }

    @Test
    public void testFilterStateReset() {
        this.login();
        tester.startPage((Page)new LayerPage());
        tester.assertRenderedPage(LayerPage.class);
        tester.assertNoErrorMessage();
        GeoServerTablePanel table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        Assert.assertEquals((long)2L, (long)table.getDataProvider().size());
        List<String> workspaces = this.getWorkspaces(table);
        Assert.assertTrue((boolean)workspaces.contains("cite"));
        Assert.assertTrue((boolean)workspaces.contains("gs"));
        FormTester ft = tester.newFormTester("table:filterForm");
        ft.setValue("filter", "cite");
        ft.submit("submit");
        tester.assertVisible("table:filterForm:clear");
        table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        Assert.assertEquals((long)1L, (long)table.getDataProvider().size());
        PageParameters pageParms = new PageParameters();
        pageParms.set("filter", (Object)false, INamedParameters.Type.PATH);
        tester.startPage(LayerPage.class, pageParms);
        tester.assertRenderedPage(LayerPage.class);
        tester.assertNoErrorMessage();
        tester.assertInvisible("table:filterForm:clear");
        tester.assertModelValue("table:filterForm:filter", null);
        table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        Assert.assertEquals((long)2L, (long)table.getDataProvider().size());
    }

    private List<String> getWorkspaces(GeoServerTablePanel table) {
        Iterator it = table.getDataProvider().iterator(0L, 2L);
        ArrayList<String> workspaces = new ArrayList<String>();
        while (it.hasNext()) {
            LayerInfo li = (LayerInfo)it.next();
            String wsName = li.getResource().getStore().getWorkspace().getName();
            workspaces.add(wsName);
        }
        return workspaces;
    }

    @Test
    public void testTimeColumnsToggle() {
        GeoServerInfo info = this.getGeoServerApplication().getGeoServer().getGlobal();
        info.getSettings().setShowCreatedTimeColumnsInAdminList(true);
        info.getSettings().setShowModifiedTimeColumnsInAdminList(true);
        this.getGeoServerApplication().getGeoServer().save(info);
        this.login();
        tester.startPage((Page)new LayerPage());
        tester.assertRenderedPage(LayerPage.class);
        tester.assertNoErrorMessage();
        GeoServerTablePanel table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("table");
        LayerProvider layerProvider = (LayerProvider)table.getDataProvider();
        Assert.assertTrue((boolean)layerProvider.getProperties().contains(LayerProvider.CREATED_TIMESTAMP));
        Assert.assertTrue((boolean)layerProvider.getProperties().contains(LayerProvider.MODIFIED_TIMESTAMP));
    }
}

