/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.net.URL;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geotools.api.data.DataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.junit.Assert;
import org.junit.Test;

public class NewLayerPageTest
extends GeoServerWicketTestSupport {
    private static final String TABLE_PATH = "selectLayersContainer:selectLayers:layers";

    @Test
    public void testKnownStore() {
        this.login();
        DataStoreInfo store = (DataStoreInfo)this.getCatalog().getStoreByName(MockData.CDF_PREFIX, DataStoreInfo.class);
        tester.startPage((Page)new NewLayerPage(store.getId()));
        tester.assertRenderedPage(NewLayerPage.class);
        Assert.assertNull((Object)tester.getComponentFromLastRenderedPage("selector"));
        GeoServerTablePanel table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage(TABLE_PATH);
        Assert.assertEquals((long)this.getCatalog().getResourcesByStore((StoreInfo)store, FeatureTypeInfo.class).size(), (long)table.getDataProvider().size());
    }

    @Test
    public void testAjaxChooser() {
        this.login();
        tester.startPage((Page)new NewLayerPage());
        tester.assertRenderedPage(NewLayerPage.class);
        Assert.assertNull((Object)tester.getComponentFromLastRenderedPage("selectLayersContainer:selectLayers"));
        tester.newFormTester("selector").select("storesDropDown", 1);
        tester.executeAjaxEvent("selector:storesDropDown", "change");
        Assert.assertNotNull((Object)tester.getComponentFromLastRenderedPage("selectLayersContainer:selectLayers"));
        tester.newFormTester("selector").setValue("storesDropDown", "");
        tester.executeAjaxEvent("selector:storesDropDown", "change");
        Assert.assertNull((Object)tester.getComponentFromLastRenderedPage("selectLayersContainer:selectLayers"));
    }

    @Test
    public void testAddLayer() throws Exception {
        this.login();
        DataStoreInfo store = (DataStoreInfo)this.getCatalog().getStoreByName(MockData.CITE_PREFIX, DataStoreInfo.class);
        NewLayerPage page = new NewLayerPage(store.getId());
        tester.startPage((Page)page);
        Object[] names = ((DataStore)store.getDataStore(null)).getTypeNames();
        Arrays.sort(names);
        tester.clickLink("selectLayersContainer:selectLayers:layers:listContainer:items:1:itemProperties:2:component:link", true);
        tester.assertRenderedPage(ResourceConfigurationPage.class);
        Assert.assertEquals((Object)names[0], (Object)((ResourceConfigurationPage)tester.getLastRenderedPage()).getResourceInfo().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddLayerFromWFSDataStore() throws Exception {
        this.login();
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        DataStoreInfo storeInfo = cb.buildDataStore(MockData.CITE_PREFIX);
        ((DataStoreInfoImpl)storeInfo).setId("1");
        this.getCatalog().add((StoreInfo)storeInfo);
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/WFSCapabilities.xml");
            storeInfo.getConnectionParameters().put(WFSDataStoreFactory.URL.key, url);
            storeInfo.getConnectionParameters().put("TESTING", Boolean.TRUE);
            ResourcePool rp = this.getCatalog().getResourcePool();
            rp.getDataStore(storeInfo);
            NewLayerPage page = new NewLayerPage(storeInfo.getId());
            tester.startPage((Page)page);
            Component link = tester.getComponentFromLastRenderedPage("selectLayersContainer").get("createCascadedWFSStoredQueryContainer");
            Assert.assertTrue((boolean)link.isVisible());
        }
        finally {
            this.getCatalog().remove((StoreInfo)storeInfo);
        }
    }

    @Test
    public void testAddLayerFromNotWFSDataStore() throws Exception {
        this.login();
        DataStoreInfo store = (DataStoreInfo)this.getCatalog().getStoreByName(MockData.CITE_PREFIX, DataStoreInfo.class);
        NewLayerPage page = new NewLayerPage(store.getId());
        tester.startPage((Page)page);
        Component link = tester.getComponentFromLastRenderedPage("selectLayersContainer").get("createCascadedWFSStoredQueryContainer");
        Assert.assertFalse((boolean)link.isVisible());
    }
}

