/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.TagTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.LayerGroupStyleImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.web.InternationalStringPanel;
import org.geoserver.web.data.layergroup.LayerGroupBaseTest;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.layergroup.LayerGroupEntry;
import org.geoserver.web.data.layergroup.LayerGroupPage;
import org.geoserver.web.data.resource.MetadataLinkEditor;
import org.geoserver.web.wicket.DecimalTextField;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.InternationalString;
import org.geotools.factory.CommonFactoryFinder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerGroupEditPageTest
extends LayerGroupBaseTest {
    @Test
    public void testComputeBounds() {
        LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"lakes"));
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.clickLink("publishedinfo:tabs:panel:generateBounds");
        tester.submitForm("publishedinfo");
    }

    @Test
    public void testComputeBoundsFromCRS() {
        LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"lakes"));
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:bounds:crsContainer:crs:srs", "EPSG:4326");
        tester.clickLink("publishedinfo:tabs:panel:generateBoundsFromCRS", true);
        tester.assertComponentOnAjaxResponse("publishedinfo:tabs:panel:bounds");
        Component ajaxComponent = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:bounds");
        assert (ajaxComponent instanceof EnvelopePanel);
        EnvelopePanel envPanel = (EnvelopePanel)ajaxComponent;
        Assert.assertEquals((Object)((DecimalTextField)envPanel.get("minX")).getModelObject(), (Object)-180.0);
        Assert.assertEquals((Object)((DecimalTextField)envPanel.get("minY")).getModelObject(), (Object)-90.0);
        Assert.assertEquals((Object)((DecimalTextField)envPanel.get("maxX")).getModelObject(), (Object)180.0);
        Assert.assertEquals((Object)((DecimalTextField)envPanel.get("maxY")).getModelObject(), (Object)90.0);
    }

    @Before
    public void doLogin() {
        this.login();
    }

    @Test
    public void testMissingName() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        FormTester form = tester.newFormTester("publishedinfo");
        form.submit();
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Name' is required.", "Field 'Bounds' is required."});
    }

    @Test
    public void testMissingCRS() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:name", "lakes");
        form.setValue("tabs:panel:bounds:minX", "-180");
        form.setValue("tabs:panel:bounds:minY", "-90");
        form.setValue("tabs:panel:bounds:maxX", "180");
        form.setValue("tabs:panel:bounds:maxY", "90");
        page.lgEntryPanel.getEntries().add(new LayerGroupEntry((PublishedInfo)this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES)), null));
        form.submit("save");
        tester.assertRenderedPage(LayerGroupEditPage.class);
        Assert.assertEquals((long)1L, (long)tester.getMessages(400).size());
        String message = ((Serializable)tester.getMessages(400).get(0)).toString();
        Assert.assertTrue((boolean)message.contains("Bounds"));
    }

    @Test
    public void testDuplicateName() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:name", "lakes");
        form.setValue("tabs:panel:bounds:minX", "0");
        form.setValue("tabs:panel:bounds:minY", "0");
        form.setValue("tabs:panel:bounds:maxX", "1");
        form.setValue("tabs:panel:bounds:maxY", "1");
        form.setValue("tabs:panel:bounds:crsContainer:crs:srs", "EPSG:4326");
        page.lgEntryPanel.getEntries().add(new LayerGroupEntry((PublishedInfo)this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES)), null));
        form.submit("save");
        tester.assertRenderedPage(LayerGroupEditPage.class);
        Assert.assertEquals((long)1L, (long)tester.getMessages(400).size());
        Assert.assertTrue((boolean)((Serializable)tester.getMessages(400).get(0)).toString().endsWith("Layer group named 'lakes' already exists"));
    }

    @Test
    public void testNewName() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:name", "newGroup");
        form.submit();
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Bounds' is required."});
    }

    @Test
    public void testLayerLink() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.clickLink("publishedinfo:tabs:panel:layers:addLayer");
        tester.assertNoErrorMessage();
        tester.assertComponent("publishedinfo:tabs:panel:layers:popup:modal:overlay:dialog:content:content:listContainer:items", DataView.class);
        DataView dataView = (DataView)page.lgEntryPanel.get("popup:modal:overlay:dialog:content:content:listContainer:items");
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        int layerCount = catalog.count(LayerInfo.class, (Filter)Filter.INCLUDE);
        int rowCount = (int)dataView.getRowCount();
        Assert.assertEquals((long)layerCount, (long)rowCount);
    }

    @Test
    public void testStyleGroupLink() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.clickLink("publishedinfo:tabs:panel:layers:addStyleGroup");
        tester.assertNoErrorMessage();
        tester.assertComponent("publishedinfo:tabs:panel:layers:popup:modal:overlay:dialog:content:content:listContainer:items", DataView.class);
        DataView dataView = (DataView)page.lgEntryPanel.get("popup:modal:overlay:dialog:content:content:listContainer:items");
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        int styleCount = catalog.count(StyleInfo.class, (Filter)Filter.INCLUDE);
        int rowCount = (int)dataView.getRowCount();
        Assert.assertEquals((long)styleCount, (long)rowCount);
    }

    @Test
    public void testLayerLinkWithWorkspace() {
        LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("workspace", (Object)"cite").add("group", (Object)"bridges"));
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.clickLink("publishedinfo:tabs:panel:layers:addLayer");
        tester.assertNoErrorMessage();
        tester.assertComponent("publishedinfo:tabs:panel:layers:popup:modal:overlay:dialog:content:content:listContainer:items", DataView.class);
        DataView dataView = (DataView)page.lgEntryPanel.get("popup:modal:overlay:dialog:content:content:listContainer:items");
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyIsEqualTo filter = ff.equal((Expression)ff.property("resource.store.workspace.id"), (Expression)ff.literal((Object)catalog.getWorkspaceByName("cite").getId()), true);
        int layerCount = catalog.count(LayerInfo.class, (Filter)filter);
        int rowCount = (int)dataView.getRowCount();
        Assert.assertEquals((long)layerCount, (long)rowCount);
    }

    @Test
    public void testLayerGroupLinkWithWorkspace() {
        LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("workspace", (Object)"cite").add("group", (Object)"bridges"));
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.clickLink("publishedinfo:tabs:panel:layers:addLayerGroup");
        tester.assertNoErrorMessage();
        tester.assertComponent("publishedinfo:tabs:panel:layers:popup:modal:overlay:dialog:content:content:listContainer:items", DataView.class);
        DataView dataView = (DataView)page.lgEntryPanel.get("popup:modal:overlay:dialog:content:content:listContainer:items");
        Catalog catalog = this.getGeoServerApplication().getCatalog();
        int layerGroupCount = catalog.getLayerGroupsByWorkspace("cite").size();
        int rowCount = (int)dataView.getRowCount();
        Assert.assertEquals((long)layerGroupCount, (long)rowCount);
    }

    @Test
    public void testMetadataLinks() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.assertComponent("publishedinfo:tabs:panel:metadataLinks", MetadataLinkEditor.class);
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:name", "lakes");
        form.setValue("tabs:panel:bounds:minX", "0");
        form.setValue("tabs:panel:bounds:minY", "0");
        form.setValue("tabs:panel:bounds:maxX", "1");
        form.setValue("tabs:panel:bounds:maxY", "1");
        form.setValue("tabs:panel:bounds:crsContainer:crs:srs", "EPSG:4326");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:metadataLinks:addlink", "click");
        form.setValue("tabs:panel:metadataLinks:container:table:links:0:urlBorder:urlBorder_body:metadataLinkURL", "http://test.me");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:metadataLinks:addlink", "click");
        LayerGroupInfo info = (LayerGroupInfo)page.getPublishedInfo();
        Assert.assertEquals((long)2L, (long)info.getMetadataLinks().size());
        Assert.assertEquals((Object)"http://test.me", (Object)((MetadataLinkInfo)info.getMetadataLinks().get(0)).getContent());
    }

    @Test
    public void testKeywords() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.assertComponent("publishedinfo:tabs:panel:keywords", KeywordsEditor.class);
        page.lgEntryPanel.getEntries().add(new LayerGroupEntry((PublishedInfo)this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES)), null));
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:name", "keywords-layer-group");
        form.setValue("tabs:panel:bounds:minX", "-180");
        form.setValue("tabs:panel:bounds:minY", "-90");
        form.setValue("tabs:panel:bounds:maxX", "180");
        form.setValue("tabs:panel:bounds:maxY", "90");
        form.setValue("tabs:panel:bounds:crsContainer:crs:srs", "EPSG:4326");
        form.setValue("tabs:panel:keywords:newKeyword", "keyword1");
        form.setValue("tabs:panel:keywords:lang", "en");
        form.setValue("tabs:panel:keywords:vocab", "vocab1");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:keywords:addKeyword", "click");
        form.setValue("tabs:panel:keywords:newKeyword", "keyword2");
        form.setValue("tabs:panel:keywords:lang", "pt");
        form.setValue("tabs:panel:keywords:vocab", "vocab2");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:keywords:addKeyword", "click");
        form = tester.newFormTester("publishedinfo");
        form.submit("save");
        LayerGroupInfo layerGroup = this.getCatalog().getLayerGroupByName("keywords-layer-group");
        MatcherAssert.assertThat((Object)layerGroup, (Matcher)CoreMatchers.notNullValue());
        List keywords = layerGroup.getKeywords();
        MatcherAssert.assertThat((Object)keywords, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)keywords.size(), (Matcher)CoreMatchers.is((Object)2));
        this.assertElementExist(keywords, keyword -> {
            MatcherAssert.assertThat((Object)keyword, (Matcher)CoreMatchers.notNullValue());
            return Objects.equals(keyword.getValue(), "keyword1") && Objects.equals(keyword.getLanguage(), "en") && Objects.equals(keyword.getVocabulary(), "vocab1");
        });
        this.assertElementExist(keywords, keyword -> {
            MatcherAssert.assertThat((Object)keyword, (Matcher)CoreMatchers.notNullValue());
            return Objects.equals(keyword.getValue(), "keyword2") && Objects.equals(keyword.getLanguage(), "pt") && Objects.equals(keyword.getVocabulary(), "vocab2");
        });
    }

    @Test
    public void testHTTPCaches() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        page.lgEntryPanel.getEntries().add(new LayerGroupEntry((PublishedInfo)this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES)), null));
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:name", "httpcaches-layer-group");
        form.setValue("tabs:panel:bounds:minX", "-180");
        form.setValue("tabs:panel:bounds:minY", "-90");
        form.setValue("tabs:panel:bounds:maxX", "180");
        form.setValue("tabs:panel:bounds:maxY", "90");
        form.setValue("tabs:panel:bounds:crsContainer:crs:srs", "EPSG:4326");
        tester.clickLink("publishedinfo:tabs:tabs-container:tabs:1:link");
        form = tester.newFormTester("publishedinfo");
        tester.assertComponent("publishedinfo:tabs:panel:theList:1:content:cacheAgeMax", TextField.class);
        tester.assertComponent("publishedinfo:tabs:panel:theList:1:content:cachingEnabled", CheckBox.class);
        form.setValue("tabs:panel:theList:1:content:cachingEnabled", "on");
        form.setValue("tabs:panel:theList:1:content:cacheAgeMax", "1234");
        form.submit("save");
        tester.assertNoErrorMessage();
        LayerGroupInfo layerGroup = this.getCatalog().getLayerGroupByName("httpcaches-layer-group");
        MatcherAssert.assertThat((Object)layerGroup, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((Object)1234, (Object)layerGroup.getMetadata().get("cacheAgeMax", Integer.class));
        Assert.assertTrue((boolean)((Boolean)layerGroup.getMetadata().get("cachingEnabled", Boolean.class)));
    }

    @Test
    public void testStyleGroup() {
        LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"styleGroup"));
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        FormTester form = tester.newFormTester("publishedinfo");
        form.submit("save");
        tester.assertRenderedPage(LayerGroupPage.class);
    }

    private <T> void assertElementExist(List<T> elements, Function<T, Boolean> matcher) {
        boolean found = false;
        for (T element : elements) {
            if (!matcher.apply(element).booleanValue()) continue;
            found = true;
            break;
        }
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGroupManyLayers() throws Exception {
        String groupName = "many-lakes";
        this.buildManyLakes(groupName);
        LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)groupName));
        tester.startPage((Page)page);
        Component component = tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:layers:layers:listContainer:items:50");
        Assert.assertNotNull((Object)component);
    }

    private void buildManyLakes(String groupName) throws Exception {
        Catalog catalog = this.getCatalog();
        String lakes = MockData.LAKES.getLocalPart();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName(groupName);
        for (int i = 0; i < 50; ++i) {
            lg.getLayers().add(catalog.getLayerByName(lakes));
        }
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
    }

    @Test
    public void testApply() {
        LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("workspace", (Object)"cite").add("group", (Object)"bridges"));
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        FormTester ft = tester.newFormTester("publishedinfo");
        ft.setValue("tabs:panel:bounds:minX", "0");
        ft.setValue("tabs:panel:bounds:minY", "0");
        ft.setValue("tabs:panel:bounds:minZ", "0");
        ft.setValue("tabs:panel:bounds:maxX", "1");
        ft.setValue("tabs:panel:bounds:maxY", "1");
        ft.setValue("tabs:panel:bounds:maxZ", "1");
        String newTitle = "A test title";
        ft.setValue("tabs:panel:titleAndAbstract:title", newTitle);
        ft.submit("apply");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(LayerGroupEditPage.class);
        Assert.assertEquals((Object)newTitle, (Object)this.getCatalog().getLayerGroupByName("cite:bridges").getTitle());
    }

    @Test
    public void testInternationalContent() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.assertComponent("publishedinfo:tabs:panel:titleAndAbstract:internationalTitle", InternationalStringPanel.class);
        tester.assertComponent("publishedinfo:tabs:panel:titleAndAbstract:internationalAbstract", InternationalStringPanel.class);
        page.lgEntryPanel.getEntries().add(new LayerGroupEntry((PublishedInfo)this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES)), null));
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:internationalTitle:container:addNew", "click");
        form.select("tabs:panel:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:internationalTitle:container:addNew", "click");
        form.select("tabs:panel:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:0:component:border:border_body:select", 20);
        form.setValue("tabs:panel:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "another international title");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:2:component:remove", "click");
        form.setValue("tabs:panel:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:internationalAbstract:container:addNew", "click");
        form.select("tabs:panel:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        form.setValue("tabs:panel:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international title");
        form.setValue("tabs:panel:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international abstract");
        form.setValue("tabs:panel:name", "international-layer-group");
        form.setValue("tabs:panel:bounds:minX", "-180");
        form.setValue("tabs:panel:bounds:minY", "-90");
        form.setValue("tabs:panel:bounds:maxX", "180");
        form.setValue("tabs:panel:bounds:maxY", "90");
        form.setValue("tabs:panel:bounds:crsContainer:crs:srs", "EPSG:4326");
        form.select("tabs:panel:mode", 0);
        form.submit("save");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testEmptyLangInternationalContent() {
        LayerGroupEditPage page = new LayerGroupEditPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(LayerGroupEditPage.class);
        tester.assertComponent("publishedinfo:tabs:panel:titleAndAbstract:internationalTitle", InternationalStringPanel.class);
        tester.assertComponent("publishedinfo:tabs:panel:titleAndAbstract:internationalAbstract", InternationalStringPanel.class);
        page.lgEntryPanel.getEntries().add(new LayerGroupEntry((PublishedInfo)this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES)), null));
        FormTester form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:titleLabel:titleLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:internationalTitle:container:addNew", "click");
        form.select("tabs:panel:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:internationalTitle:container:addNew", "click");
        form.setValue("tabs:panel:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", true);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:abstractLabel:abstractLabel_i18nCheckbox", "change");
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:internationalAbstract:container:addNew", "click");
        form.select("tabs:panel:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:0:component:border:border_body:select", 10);
        tester.executeAjaxEvent("publishedinfo:tabs:panel:titleAndAbstract:internationalAbstract:container:addNew", "click");
        form = tester.newFormTester("publishedinfo");
        form.setValue("tabs:panel:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international title");
        form.setValue("tabs:panel:titleAndAbstract:internationalTitle:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "empty lang international title");
        form.setValue("tabs:panel:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "an international abstract");
        form.setValue("tabs:panel:titleAndAbstract:internationalAbstract:container:tablePanel:listContainer:items:2:itemProperties:1:component:border:border_body:txt", "empty lang international abstract");
        form.setValue("tabs:panel:name", "bridges-i18n-layer-group");
        form.setValue("tabs:panel:bounds:minX", "-180");
        form.setValue("tabs:panel:bounds:minY", "-90");
        form.setValue("tabs:panel:bounds:maxX", "180");
        form.setValue("tabs:panel:bounds:maxY", "90");
        form.setValue("tabs:panel:bounds:crsContainer:crs:srs", "EPSG:4326");
        form.submit("save");
        tester.assertNoErrorMessage();
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("bridges-i18n-layer-group");
        InternationalString i18nTitle = groupInfo.getInternationalTitle();
        Assert.assertEquals((Object)"empty lang international title", (Object)i18nTitle.toString(null));
        InternationalString i18nAbstract = groupInfo.getInternationalAbstract();
        Assert.assertEquals((Object)"empty lang international abstract", (Object)i18nAbstract.toString(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testLayerGroupStyle() {
        LayerGroupInfo groupInfo = null;
        try {
            LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("workspace", (Object)"cite").add("group", (Object)"bridges"));
            tester.startPage((Page)page);
            tester.assertRenderedPage(LayerGroupEditPage.class);
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:addNew", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:addLayer", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:popup:modal:overlay:dialog:content:content:listContainer:items:1:itemProperties:0:component:link", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:addLayerGroup", "click");
            FormTester ft = tester.newFormTester("publishedinfo");
            ft.setValue("tabs:panel:bounds:minX", "0");
            ft.setValue("tabs:panel:bounds:minY", "0");
            ft.setValue("tabs:panel:bounds:minZ", "0");
            ft.setValue("tabs:panel:bounds:maxX", "1");
            ft.setValue("tabs:panel:bounds:maxY", "1");
            ft.setValue("tabs:panel:bounds:maxZ", "1");
            ft.setValue("tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupStyleName", "LgStyleTest");
            ft.submit("save");
            tester.assertNoErrorMessage();
            groupInfo = this.getCatalog().getLayerGroupByName("cite:bridges");
            List styles = groupInfo.getLayerGroupStyles();
            Assert.assertEquals((long)1L, (long)styles.size());
            LayerGroupStyle groupStyle = (LayerGroupStyle)styles.get(0);
            Assert.assertEquals((long)1L, (long)groupStyle.getLayers().size());
            Assert.assertEquals((long)1L, (long)groupStyle.getStyles().size());
            Assert.assertEquals((Object)"LgStyleTest", (Object)groupStyle.getName().getName());
            if (groupInfo == null) return;
        }
        catch (Throwable throwable) {
            if (groupInfo == null) throw throwable;
            groupInfo.setLayerGroupStyles(new ArrayList());
            this.getCatalog().save(groupInfo);
            throw throwable;
        }
        groupInfo.setLayerGroupStyles(new ArrayList());
        this.getCatalog().save(groupInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupStyle2() throws Exception {
        this.buildLayerGroup("testLgStyles");
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("testLgStyles");
        try {
            LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"testLgStyles"));
            tester.startPage((Page)page);
            tester.assertRenderedPage(LayerGroupEditPage.class);
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:addNew", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:addLayerGroup", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:popup:modal:overlay:dialog:content:content:listContainer:items:3:itemProperties:0:component:link", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:addLayer", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:popup:modal:overlay:dialog:content:content:listContainer:items:1:itemProperties:0:component:link", "click");
            FormTester ft = tester.newFormTester("publishedinfo");
            ft.setValue("tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupStyleName", "anotherLgStyleTest");
            ft.submit("save");
            tester.assertNoErrorMessage();
            groupInfo = this.getCatalog().getLayerGroupByName("testLgStyles");
            List styles = groupInfo.getLayerGroupStyles();
            Assert.assertEquals((long)1L, (long)styles.size());
            LayerGroupStyle theStyle = (LayerGroupStyle)styles.get(0);
            Assert.assertEquals((long)2L, (long)theStyle.getLayers().size());
            Assert.assertEquals((long)2L, (long)theStyle.getStyles().size());
            Assert.assertNull(theStyle.getStyles().get(0));
            Assert.assertEquals((Object)"anotherLgStyleTest", (Object)theStyle.getName().getName());
        }
        finally {
            if (groupInfo != null) {
                this.getCatalog().remove(groupInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupStyleSelection() throws Exception {
        this.buildLayerGroup("testLgStyles-2");
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("testLgStyles-2");
        LayerGroupInfo nestedGroup = this.getCatalog().getLayerGroupByName("nestedLayerGroup");
        LayerGroupStyleImpl nestedGroupStyle = new LayerGroupStyleImpl();
        StyleInfoImpl styleName = new StyleInfoImpl(this.getCatalog());
        styleName.setName("nestedGroupStyle");
        nestedGroupStyle.setName((StyleInfo)styleName);
        nestedGroupStyle.getStyles().add(this.getCatalog().getStyleByName("BasicPolygons"));
        nestedGroupStyle.getLayers().add(this.getCatalog().getLayerByName("cite:BasicPolygons"));
        nestedGroup.getLayerGroupStyles().add(nestedGroupStyle);
        LayerGroupStyleImpl nestedGroupStyle2 = new LayerGroupStyleImpl();
        StyleInfoImpl styleName2 = new StyleInfoImpl(this.getCatalog());
        styleName2.setName("nestedGroupStyle2");
        nestedGroupStyle2.setName((StyleInfo)styleName2);
        nestedGroupStyle2.getStyles().add(null);
        nestedGroupStyle2.getLayers().add(this.getCatalog().getLayerByName(this.getLayerId(MockData.LAKES)));
        nestedGroup.getLayerGroupStyles().add(nestedGroupStyle2);
        this.getCatalog().save(nestedGroup);
        LayerGroupStyleImpl groupStyleTest = new LayerGroupStyleImpl();
        styleName = new StyleInfoImpl(this.getCatalog());
        styleName.setName("styleWithNestedGroup");
        groupStyleTest.setName((StyleInfo)styleName);
        groupStyleTest.getLayers().add(nestedGroup);
        groupStyleTest.getStyles().add(null);
        groupInfo.getLayerGroupStyles().add(groupStyleTest);
        this.getCatalog().save(groupInfo);
        try {
            LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"testLgStyles-2"));
            tester.startPage((Page)page);
            tester.assertRenderedPage(LayerGroupEditPage.class);
            FormTester ft = tester.newFormTester("publishedinfo");
            ft.setValue("tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:layers:listContainer:items:1:itemProperties:4:component:checkbox", false);
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:layers:listContainer:items:1:itemProperties:4:component:checkbox", "change");
            tester.clickLink("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:layers:listContainer:items:2:itemProperties:5:component:link");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:popup:modal:overlay:dialog:content:content:listContainer:items:2:itemProperties:0:component:link", "click");
            CheckBox checkBox = (CheckBox)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupEntryPanel:layers:listContainer:items:3:itemProperties:4:component:checkbox");
            checkBox.setModelObject((Object)false);
            ft = tester.newFormTester("publishedinfo");
            ft.submit("save");
            tester.assertNoErrorMessage();
            groupInfo = this.getCatalog().getLayerGroupByName("testLgStyles-2");
            List styles = groupInfo.getLayerGroupStyles();
            Assert.assertEquals((long)1L, (long)styles.size());
            LayerGroupStyle theStyle = (LayerGroupStyle)styles.get(0);
            Assert.assertEquals((long)1L, (long)theStyle.getLayers().size());
            Assert.assertEquals((long)1L, (long)theStyle.getStyles().size());
            Assert.assertEquals((Object)"nestedGroupStyle2", (Object)((StyleInfo)theStyle.getStyles().get(0)).getName());
        }
        finally {
            if (nestedGroup != null) {
                nestedGroup.setLayerGroupStyles(new ArrayList());
                this.getCatalog().save(nestedGroup);
            }
            if (groupInfo != null) {
                this.getCatalog().remove(groupInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveStyleBtn() throws Exception {
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("nestedLayerGroup");
        LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
        StyleInfoImpl styleName = new StyleInfoImpl(this.getCatalog());
        styleName.setName("nestedGroupStyle");
        groupStyle.setName((StyleInfo)styleName);
        groupStyle.getStyles().add(this.getCatalog().getStyleByName("BasicPolygons"));
        groupStyle.getLayers().add(this.getCatalog().getLayerByName("cite:BasicPolygons"));
        groupInfo.getLayerGroupStyles().add(groupStyle);
        this.getCatalog().save(groupInfo);
        try {
            LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"nestedLayerGroup"));
            tester.startPage((Page)page);
            tester.assertRenderedPage(LayerGroupEditPage.class);
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:addNew", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:addNew", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:2:layerGroupStylePanel:remove", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:1:layerGroupStylePanel:remove", "click");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:remove", "click");
            FormTester ft = tester.newFormTester("publishedinfo");
            ft.submit("save");
            tester.assertNoErrorMessage();
            groupInfo = this.getCatalog().getLayerGroupByName("nestedLayerGroup");
            List styles = groupInfo.getLayerGroupStyles();
            Assert.assertEquals((long)0L, (long)styles.size());
        }
        finally {
            if (groupInfo != null) {
                groupInfo.setLayerGroupStyles(new ArrayList());
                this.getCatalog().save(groupInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyGroupDefaultStyle() throws Exception {
        this.buildLayerGroup("testLgStylesCopyDef", LayerGroupInfo.Mode.SINGLE);
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("testLgStylesCopyDef");
        try {
            LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"testLgStylesCopyDef"));
            tester.startPage((Page)page);
            tester.assertRenderedPage(LayerGroupEditPage.class);
            FormTester ft = tester.newFormTester("publishedinfo");
            ft.select("tabs:panel:layerGroupStyles:availableStyles", 0);
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:availableStyles", "change");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:copy", "click");
            ft = tester.newFormTester("publishedinfo");
            ft.setValue("tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupStyleName", "copiedStyleLg");
            ft.submit("save");
            tester.assertNoErrorMessage();
            groupInfo = this.getCatalog().getLayerGroupByName("testLgStylesCopyDef");
            List styles = groupInfo.getLayerGroupStyles();
            Assert.assertEquals((long)1L, (long)styles.size());
            LayerGroupStyle groupStyle1 = (LayerGroupStyle)styles.get(0);
            Assert.assertEquals((Object)groupStyle1.getLayers(), (Object)groupInfo.getLayers());
            Assert.assertEquals((Object)groupStyle1.getStyles(), (Object)groupInfo.getStyles());
        }
        finally {
            if (groupInfo != null) {
                groupInfo.setLayerGroupStyles(new ArrayList());
                this.getCatalog().save(groupInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyGroupStyle() throws Exception {
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("nestedLayerGroup");
        LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
        StyleInfoImpl styleName = new StyleInfoImpl(this.getCatalog());
        styleName.setName("nestedGroupStyle");
        groupStyle.setName((StyleInfo)styleName);
        groupStyle.getStyles().add(this.getCatalog().getStyleByName("BasicPolygons"));
        groupStyle.getLayers().add(this.getCatalog().getLayerByName("cite:BasicPolygons"));
        groupInfo.getLayerGroupStyles().add(groupStyle);
        this.getCatalog().save(groupInfo);
        try {
            LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"nestedLayerGroup"));
            tester.startPage((Page)page);
            tester.assertRenderedPage(LayerGroupEditPage.class);
            FormTester ft = tester.newFormTester("publishedinfo");
            ft.select("tabs:panel:layerGroupStyles:availableStyles", 1);
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:availableStyles", "change");
            tester.executeAjaxEvent("publishedinfo:tabs:panel:layerGroupStyles:copy", "click");
            ft = tester.newFormTester("publishedinfo");
            ft.setValue("tabs:panel:layerGroupStyles:listContainer:styleList:1:layerGroupStylePanel:layerGroupStyleName", "copiedStyleLg");
            ft.submit("save");
            tester.assertNoErrorMessage();
            groupInfo = this.getCatalog().getLayerGroupByName("nestedLayerGroup");
            List styles = groupInfo.getLayerGroupStyles();
            Assert.assertEquals((long)2L, (long)styles.size());
            LayerGroupStyle groupStyle1 = (LayerGroupStyle)styles.get(0);
            LayerGroupStyle groupStyle2 = (LayerGroupStyle)styles.get(1);
            Assert.assertEquals((Object)groupStyle1.getLayers(), (Object)groupStyle2.getLayers());
            Assert.assertEquals((Object)groupStyle1.getStyles(), (Object)groupStyle2.getStyles());
        }
        finally {
            if (groupInfo != null) {
                groupInfo.setLayerGroupStyles(new ArrayList());
                this.getCatalog().save(groupInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupStyleVisibility() throws Exception {
        this.buildLayerGroup("testLgStylesNamed", LayerGroupInfo.Mode.NAMED);
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("testLgStylesNamed");
        try {
            LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)groupInfo.getName()));
            tester.startPage((Page)page);
            tester.assertRenderedPage(LayerGroupEditPage.class);
            Assert.assertNull((Object)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:layerGroupStyles"));
            FormTester ft = tester.newFormTester("publishedinfo");
            ft.select("tabs:panel:mode", 0);
            tester.executeAjaxEvent("publishedinfo:tabs:panel:mode", "change");
            Assert.assertNotNull((Object)tester.getComponentFromLastRenderedPage("publishedinfo:tabs:panel:layerGroupStyles"));
        }
        finally {
            if (groupInfo != null) {
                this.getCatalog().remove(groupInfo);
            }
        }
    }

    private void buildLayerGroup(String groupName) throws Exception {
        this.buildLayerGroup(groupName, LayerGroupInfo.Mode.SINGLE);
    }

    private void buildLayerGroup(String groupName, LayerGroupInfo.Mode mode) throws Exception {
        Catalog catalog = this.getCatalog();
        String lakes = MockData.BASIC_POLYGONS.getLocalPart();
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName(groupName);
        lg.setMode(mode);
        lg.getLayers().add(catalog.getLayerByName(lakes));
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupStyleEditingIsolation() throws Exception {
        this.buildLayerGroup("testLgStylesEditing", LayerGroupInfo.Mode.OPAQUE_CONTAINER);
        LayerGroupInfo groupInfo = this.getCatalog().getLayerGroupByName("testLgStylesEditing");
        LayerGroupStyleImpl groupStyle = new LayerGroupStyleImpl();
        StyleInfoImpl styleName = new StyleInfoImpl(this.getCatalog());
        styleName.setName("editingGroupStyle");
        groupStyle.setName((StyleInfo)styleName);
        groupStyle.getStyles().add(this.getCatalog().getStyleByName("BasicPolygons"));
        groupStyle.getLayers().add(this.getCatalog().getLayerByName("cite:BasicPolygons"));
        groupInfo.getLayerGroupStyles().add(groupStyle);
        this.getCatalog().save(groupInfo);
        try {
            LayerGroupEditPage page = new LayerGroupEditPage(new PageParameters().add("group", (Object)"testLgStylesEditing"));
            tester.startPage((Page)page);
            tester.assertRenderedPage(LayerGroupEditPage.class);
            FormTester ft = tester.newFormTester("publishedinfo");
            ft.setValue("tabs:panel:layerGroupStyles:listContainer:styleList:0:layerGroupStylePanel:layerGroupStyleName", "changeName");
            groupInfo = this.getCatalog().getLayerGroupByName(groupInfo.prefixedName());
            String savedName = ((LayerGroupStyle)groupInfo.getLayerGroupStyles().get(0)).getName().getName();
            Assert.assertNotEquals((Object)"changeName", (Object)savedName);
            Assert.assertEquals((Object)"editingGroupStyle", (Object)savedName);
            ft.submit("save");
            tester.assertNoErrorMessage();
            groupInfo = this.getCatalog().getLayerGroupByName(groupInfo.prefixedName());
            savedName = ((LayerGroupStyle)groupInfo.getLayerGroupStyles().get(0)).getName().getName();
            Assert.assertEquals((Object)"changeName", (Object)savedName);
        }
        finally {
            if (groupInfo != null) {
                groupInfo.setLayerGroupStyles(new ArrayList());
                this.getCatalog().save(groupInfo);
            }
        }
    }

    @Test
    public void testWicketDNDPatch() {
        tester.startPage((Page)new LayerGroupEditPage(new PageParameters().add("group", (Object)"lakes")));
        tester.assertRenderedPage(LayerGroupEditPage.class);
        List scripts = TagTester.createTags((String)tester.getLastResponseAsString(), tag -> "script".equals(tag.getName()), (boolean)false).stream().map(tag -> tag.getAttribute("src")).filter(Objects::nonNull).collect(Collectors.toList());
        int dndIndex = ListUtils.indexOf(scripts, script -> script.contains("wicketdnd.Transfer/wicket-dnd"));
        int gsIndex = ListUtils.indexOf(scripts, script -> script.contains("org.geoserver.web.wicket.GeoServerDNDBehavior/gs-wicket-dnd"));
        MatcherAssert.assertThat((String)"Missing wicket-dnd.js", (Object)dndIndex, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(-1)));
        MatcherAssert.assertThat((String)"Missing gs-wicket-dnd.js", (Object)gsIndex, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(-1)));
        MatcherAssert.assertThat((String)"gs-wicket-dnd.js is not after wicket-dnd.js", (Object)gsIndex, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(dndIndex)));
    }
}

