/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geoserver.security.impl.FileSandboxEnforcer;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.AbstractDataAccessPage;
import org.geoserver.web.data.store.DataAccessEditPage;
import org.geoserver.web.data.store.DataAccessNewPage;
import org.geoserver.web.data.store.panel.FileParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.geotools.geopkg.GeoPkgDataStoreFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class DataAccessNewPageTest
extends GeoServerWicketTestSupport {
    private static final boolean debugMode = false;
    private static final String ROLE_CITE = "ROLE_CITE";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerExtensions.bean(FileSandboxEnforcer.class, (ApplicationContext)applicationContext);
    }

    private AbstractDataAccessPage startPage() {
        this.login();
        String dataStoreFactoryDisplayName = new PropertyDataStoreFactory().getDisplayName();
        DataAccessNewPage page = new DataAccessNewPage(dataStoreFactoryDisplayName);
        tester.startPage((Page)page);
        return page;
    }

    @Test
    public void testInitCreateNewDataStoreInvalidDataStoreFactoryName() {
        String dataStoreFactoryDisplayName = "_invalid_";
        try {
            this.login();
            new DataAccessNewPage("_invalid_");
            Assert.fail((String)"Expected IAE on invalid datastore factory name");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Can't find the factory"));
        }
    }

    @Test
    public void testPageRendersOnLoad() {
        PropertyDataStoreFactory dataStoreFactory = new PropertyDataStoreFactory();
        String dataStoreFactoryDisplayName = dataStoreFactory.getDisplayName();
        this.startPage();
        tester.assertLabel("dataStoreForm:storeType", dataStoreFactoryDisplayName);
        tester.assertLabel("dataStoreForm:storeTypeDescription", dataStoreFactory.getDescription());
        tester.assertComponent("dataStoreForm:workspacePanel", WorkspacePanel.class);
    }

    @Test
    public void testDefaultWorkspace() {
        this.startPage();
        WorkspaceInfo defaultWs = this.getCatalog().getDefaultWorkspace();
        tester.assertModelValue("dataStoreForm:workspacePanel:border:border_body:paramValue", (Object)defaultWs);
        WorkspaceInfo anotherWs = this.getCatalog().getFactory().createWorkspace();
        anotherWs.setName("anotherWs");
        this.getCatalog().add(anotherWs);
        this.getCatalog().setDefaultWorkspace(anotherWs);
        anotherWs = this.getCatalog().getDefaultWorkspace();
        this.startPage();
        tester.assertModelValue("dataStoreForm:workspacePanel:border:border_body:paramValue", (Object)anotherWs);
    }

    @Test
    public void testDefaultNamespace() {
        String namespacePath = "dataStoreForm:parametersPanel:parameters:1:parameterPanel:paramValue";
        this.startPage();
        NamespaceInfo defaultNs = this.getCatalog().getDefaultNamespace();
        tester.assertModelValue("dataStoreForm:parametersPanel:parameters:1:parameterPanel:paramValue", (Object)defaultNs.getURI());
    }

    @Test
    public void testDataStoreParametersAreCreated() {
        this.startPage();
        List<Object> parametersListViewValues = Arrays.asList("directory", "namespace");
        tester.assertComponent("dataStoreForm:parametersPanel:parameters", ListView.class);
        tester.assertModelValue("dataStoreForm:parametersPanel:parameters", parametersListViewValues);
    }

    @Test
    public void testInitCreateNewDataStoreSetsNamespaceParam() {
        AbstractDataAccessPage page = this.startPage();
        page.get(null);
    }

    @Test
    public void testGeoPackagePage() {
        String displayName = new GeoPkgDataStoreFactory().getDisplayName();
        this.login();
        DataAccessNewPage page = new DataAccessNewPage(displayName);
        tester.startPage((Page)page);
        Component component = tester.getComponentFromLastRenderedPage("dataStoreForm:parametersPanel:parameters:1:parameterPanel");
        MatcherAssert.assertThat((Object)component, (Matcher)CoreMatchers.instanceOf(FileParamPanel.class));
    }

    @Test
    public void testNewDataStoreSave() {
        this.startPage();
        FormTester ft = tester.newFormTester("dataStoreForm");
        ft.setValue("parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue", "file:cdf");
        ft.setValue("dataStoreNamePanel:border:border_body:paramValue", "cdf2");
        ft.submit("save");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(NewLayerPage.class);
        DataStoreInfo store = this.getCatalog().getDataStoreByName("cdf2");
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((Object)"file:cdf", store.getConnectionParameters().get("directory"));
    }

    @Test
    public void testNewDataStoreApply() {
        this.startPage();
        FormTester ft = tester.newFormTester("dataStoreForm");
        ft.setValue("parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue", "file:cdf");
        ft.setValue("dataStoreNamePanel:border:border_body:paramValue", "cdf3");
        ft.submit("apply");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(DataAccessEditPage.class);
        DataStoreInfo store = this.getCatalog().getDataStoreByName("cdf3");
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((Object)"file:cdf", store.getConnectionParameters().get("directory"));
    }

    @Test
    public void testDisableOnConnFailureCheckbox() {
        String name = "autodisablingStore";
        this.startPage();
        FormTester ft = tester.newFormTester("dataStoreForm");
        ft.setValue("parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue", "file:cdf");
        ft.setValue("dataStoreNamePanel:border:border_body:paramValue", name);
        Component component = tester.getComponentFromLastRenderedPage("dataStoreForm:disableOnConnFailurePanel:paramValue");
        CheckBox checkBox = (CheckBox)component;
        Assert.assertFalse((boolean)Boolean.valueOf(checkBox.getInput()));
        ft.setValue("disableOnConnFailurePanel:paramValue", true);
        ft.submit("save");
        tester.assertNoErrorMessage();
        DataStoreInfo store = this.getCatalog().getDataStoreByName(name);
        Assert.assertNotNull((Object)store);
        Assert.assertTrue((boolean)store.isDisableOnConnFailure());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataStoreNewSandbox() throws Exception {
        File sandbox = new File("./target/sandbox").getCanonicalFile();
        File citeFolder = new File(sandbox, MockData.CITE_PREFIX);
        File toppFolder = new File(sandbox, "topp");
        citeFolder.mkdirs();
        toppFolder.mkdirs();
        Resource layerSecurity = this.getDataDirectory().get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("filesystemSandbox", sandbox.getAbsolutePath());
        properties.put("cite.*.a", ROLE_CITE);
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "sandbox");
        }
        DefaultFileAccessManager fam = (DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class, (ApplicationContext)applicationContext);
        fam.reload();
        this.startPage();
        try {
            this.login("cite", "pwd", new String[]{ROLE_CITE});
            FormTester ft = tester.newFormTester("dataStoreForm");
            DropDownChoice select = (DropDownChoice)tester.getComponentFromLastRenderedPage("dataStoreForm:workspacePanel:border:border_body:paramValue");
            List workspaces = select.getChoices();
            int citeIdx = -1;
            for (int i = 0; i < workspaces.size(); ++i) {
                if (!MockData.CITE_PREFIX.equals(((WorkspaceInfo)workspaces.get(i)).getName())) continue;
                citeIdx = i;
                break;
            }
            String storeName = "cite2";
            String toppPath = toppFolder.getAbsolutePath();
            ft.setValue("dataStoreNamePanel:border:border_body:paramValue", storeName);
            ft.select("workspacePanel:border:border_body:paramValue", citeIdx);
            ft.setValue("parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue", toppPath);
            ft.submit("save");
            List messages = tester.getMessages(400);
            Assert.assertEquals((long)1L, (long)messages.size());
            DataAccessNewPageTest.checkSandboxDeniedMessage(((Serializable)messages.get(0)).toString(), toppPath);
            tester.clearFeedbackMessages();
            DataAccessNewPageTest.checkSandboxDeniedMessage(tester.getLastResponseAsString(), toppPath);
            String citePath = citeFolder.getAbsolutePath();
            ft = tester.newFormTester("dataStoreForm");
            ft.setValue("dataStoreNamePanel:border:border_body:paramValue", storeName);
            ft.select("workspacePanel:border:border_body:paramValue", citeIdx);
            ft.setValue("parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue", citePath);
            ft.submit("save");
            tester.assertNoErrorMessage();
            DataStoreInfo store = this.getCatalog().getDataStoreByName(storeName);
            Assert.assertEquals((Object)("file://" + citePath.replace("\\", "/")), store.getConnectionParameters().get("directory"));
        }
        finally {
            layerSecurity.delete();
            fam.reload();
        }
    }

    private static void checkSandboxDeniedMessage(String message, String toppPath) {
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Access to "), (Matcher)Matchers.containsString((String)toppPath), (Matcher)Matchers.containsString((String)" denied by file sandboxing")));
    }
}

