/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.AbstractDataAccessPage;
import org.geoserver.web.data.store.DataAccessNewPage;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geotools.data.shapefile.ShapefileDirectoryFactory;
import org.junit.Assert;
import org.junit.Test;

public class ShapefileDirectoryStorePageTest
extends GeoServerWicketTestSupport {
    private static final boolean debugMode = false;

    private AbstractDataAccessPage startPage() {
        String dataStoreFactoryDisplayName = new ShapefileDirectoryFactory().getDisplayName();
        this.login();
        DataAccessNewPage page = new DataAccessNewPage(dataStoreFactoryDisplayName);
        tester.startPage((Page)page);
        return page;
    }

    @Test
    public void testChangeWorkspaceNamespace() throws Exception {
        this.startPage();
        WorkspaceInfo defaultWs = this.getCatalog().getDefaultWorkspace();
        tester.assertModelValue("dataStoreForm:workspacePanel:border:border_body:paramValue", (Object)defaultWs);
        FormTester ft = tester.newFormTester("dataStoreForm");
        ft.setValue("dataStoreNamePanel:border:border_body:paramValue", "testStore");
        ft.setValue("parametersPanel:url:fileInput:border:border_body:paramValue", "file://" + new File("./target").getCanonicalPath());
        ft.select("workspacePanel:border:border_body:paramValue", 2);
        tester.executeAjaxEvent("dataStoreForm:workspacePanel:border:border_body:paramValue", "change");
        ft.setValue("dataStoreNamePanel:border:border_body:paramValue", "testStore");
        ft.setValue("parametersPanel:url:fileInput:border:border_body:paramValue", "file://" + new File("./target").getCanonicalPath());
        ft.select("workspacePanel:border:border_body:paramValue", 2);
        ft.setValue("parametersPanel:skipScan:paramValue", true);
        tester.executeAjaxEvent("dataStoreForm:parametersPanel:skipScan:paramValue", "change");
        ft.submit();
        tester.executeAjaxEvent("dataStoreForm:save", "click");
        WorkspacesModel wm = new WorkspacesModel();
        List wl = (List)wm.getObject();
        WorkspaceInfo ws = (WorkspaceInfo)wl.get(2);
        StoreInfo store = this.getCatalog().getStoreByName("testStore", DataStoreInfo.class);
        Assert.assertEquals((Object)this.getCatalog().getNamespaceByPrefix(ws.getName()).getURI(), store.getConnectionParameters().get("namespace"));
        Assert.assertEquals((Object)true, store.getConnectionParameters().get("skipScan"));
    }
}

