/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.StoreModel;
import org.geoserver.web.data.store.StoresModel;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;
import org.junit.Assert;
import org.junit.Test;

public class StoreModelTest
extends GeoServerWicketTestSupport {
    @Test
    public void testStoreModel() throws Exception {
        DataStoreInfo s = this.getFeatureTypeInfo(MockData.PRIMITIVEGEOFEATURE).getStore();
        StoreModel model = new StoreModel((StoreInfo)s);
        model = this.serializeDeserialize(model);
        Assert.assertEquals((Object)s, (Object)model.getObject());
        model.detach();
        Assert.assertEquals((Object)s, (Object)model.getObject());
    }

    @Test
    public void testStoreModelSetNull() throws Exception {
        DataStoreInfo s = this.getFeatureTypeInfo(MockData.PRIMITIVEGEOFEATURE).getStore();
        StoreModel model = new StoreModel((StoreInfo)s);
        model = this.serializeDeserialize(model);
        Assert.assertEquals((Object)s, (Object)model.getObject());
        model.detach();
        Assert.assertEquals((Object)s, (Object)model.getObject());
        model.setObject(null);
        Assert.assertNull((Object)model.getObject());
        model = this.serializeDeserialize(model);
        model.detach();
        Assert.assertNull((Object)model.getObject());
    }

    @Test
    public void testStoresModel() throws Exception {
        WorkspaceDetachableModel ws = new WorkspaceDetachableModel(this.getCatalog().getWorkspaceByName("sf"));
        StoresModel model = new StoresModel((IModel)ws);
        List stores = this.getCatalog().getStoresByWorkspace("ws", StoreInfo.class);
        for (StoreInfo s : stores) {
            Assert.assertTrue((boolean)((List)model.getObject()).contains(s));
        }
        model.detach();
        for (StoreInfo s : stores) {
            Assert.assertTrue((boolean)((List)model.getObject()).contains(s));
        }
        model = this.serializeDeserialize(model);
        for (StoreInfo s : stores) {
            Assert.assertTrue((boolean)((List)model.getObject()).contains(s));
        }
    }

    <T extends IModel> T serializeDeserialize(T model) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream objout = new ObjectOutputStream(bout);
        objout.writeObject(model);
        objout.flush();
        objout.close();
        ObjectInputStream objin = new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray()));
        return (T)((IModel)objin.readObject());
    }
}

