/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.StoreProvider;
import org.geotools.api.filter.Filter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StorePageTest
extends GeoServerWicketTestSupport {
    @Before
    public void init() {
        this.login();
        tester.startPage(StorePage.class);
    }

    @Test
    public void testLoad() {
        tester.assertRenderedPage(StorePage.class);
        tester.assertNoErrorMessage();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Catalog catalog = this.getCatalog();
        Assert.assertEquals((long)dv.size(), (long)catalog.getStores(StoreInfo.class).size());
        IDataProvider dataProvider = dv.getDataProvider();
        Assert.assertTrue((boolean)(dataProvider instanceof StoreProvider));
        StoreProvider provider = (StoreProvider)dataProvider;
        boolean catchedException = false;
        try {
            provider.getItems();
        }
        catch (UnsupportedOperationException e) {
            catchedException = true;
        }
        Assert.assertTrue((boolean)catchedException);
        StoreInfo actual = (StoreInfo)provider.iterator(0L, 1L).next();
        try (CloseableIterator list = catalog.list(StoreInfo.class, (Filter)Filter.INCLUDE, Integer.valueOf(0), Integer.valueOf(1), Predicates.sortBy((String)"name", (boolean)true));){
            Assert.assertTrue((boolean)list.hasNext());
            StoreInfo expected = (StoreInfo)list.next();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testTimeColumnsToggle() {
        GeoServerInfo info = this.getGeoServerApplication().getGeoServer().getGlobal();
        info.getSettings().setShowCreatedTimeColumnsInAdminList(true);
        info.getSettings().setShowModifiedTimeColumnsInAdminList(true);
        this.getGeoServerApplication().getGeoServer().save(info);
        this.login();
        tester.startPage(StorePage.class);
        tester.assertRenderedPage(StorePage.class);
        tester.assertNoErrorMessage();
        DataView dv = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        Catalog catalog = this.getCatalog();
        Assert.assertEquals((long)dv.size(), (long)catalog.getStores(StoreInfo.class).size());
        IDataProvider dataProvider = dv.getDataProvider();
        Assert.assertTrue((boolean)(dataProvider instanceof StoreProvider));
        StoreProvider provider = (StoreProvider)dataProvider;
        Assert.assertTrue((boolean)provider.getProperties().contains(StoreProvider.CREATED_TIMESTAMP));
        Assert.assertTrue((boolean)provider.getProperties().contains(StoreProvider.MODIFIED_TIMESTAMP));
    }

    @Test
    public void testSerializedProvider() throws Exception {
        StoreProvider provider2;
        byte[] serialized;
        StoreProvider provider = new StoreProvider();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                oos.writeObject(provider);
            }
            serialized = os.toByteArray();
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(serialized);
             ObjectInputStream ois = new ObjectInputStream(is);){
            provider2 = (StoreProvider)ois.readObject();
        }
        Assert.assertEquals((Object)provider.getProperties(), (Object)provider2.getProperties());
    }
}

