/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.util.HashMap;
import org.apache.wicket.model.Model;
import org.geoserver.web.data.store.DefaultDataStoreEditPanel;
import org.junit.Assert;
import org.junit.Test;

public class URLModelTest {
    private static final String URL_VALUE = "https://www.geoserver.org";
    private static final String URL_PARAM = "urlParam";

    @Test
    public void testHttpsURLSetValue() {
        HashMap params = new HashMap();
        DefaultDataStoreEditPanel.URLModel urlModel = new DefaultDataStoreEditPanel.URLModel(Model.ofMap(params), URL_PARAM);
        urlModel.setObject(URL_VALUE);
        Assert.assertEquals((Object)URL_VALUE, (Object)urlModel.getObject());
    }

    @Test
    public void testHttpURLSetValue() {
        String urlValue = "http://www.geoserver.org/";
        HashMap params = new HashMap();
        DefaultDataStoreEditPanel.URLModel urlModel = new DefaultDataStoreEditPanel.URLModel(Model.ofMap(params), URL_PARAM);
        urlModel.setObject("http://www.geoserver.org/");
        Assert.assertEquals((Object)"http://www.geoserver.org/", (Object)urlModel.getObject());
    }

    @Test
    public void testFileURLSetValue() {
        String urlValue = "file:///home/fernando/mino.xml";
        HashMap params = new HashMap();
        DefaultDataStoreEditPanel.URLModel urlModel = new DefaultDataStoreEditPanel.URLModel(Model.ofMap(params), URL_PARAM);
        urlModel.setObject("file:///home/fernando/mino.xml");
        Assert.assertEquals((Object)"file:///home/fernando/mino.xml", (Object)urlModel.getObject());
    }

    @Test
    public void testNonProtocolUrl() {
        String urlValue = "/home/geosolutions/file.xml";
        HashMap params = new HashMap();
        DefaultDataStoreEditPanel.URLModel urlModel = new DefaultDataStoreEditPanel.URLModel(Model.ofMap(params), URL_PARAM);
        urlModel.setObject("/home/geosolutions/file.xml");
        Assert.assertEquals((Object)"file:///home/geosolutions/file.xml", (Object)urlModel.getObject());
    }
}

