/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.web.data.workspace.WorkspaceProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkspaceProviderTest {
    private WorkspaceProvider provider;
    private Catalog catalog;
    private WorkspaceInfo w1;
    private WorkspaceInfo w2;
    private WorkspaceInfo w3;
    private WorkspaceInfo w4;
    private SettingsInfo settings;

    @Before
    public void setUp() {
        this.catalog = new CatalogImpl();
        this.w1 = this.add("w1");
        this.w2 = this.add("w2");
        this.w3 = this.add("w3");
        this.w4 = this.add("w4");
        this.settings = new SettingsInfoImpl();
        this.provider = new WorkspaceProvider(){

            public Catalog getCatalog() {
                return WorkspaceProviderTest.this.catalog;
            }

            protected SettingsInfo getSettings() {
                return WorkspaceProviderTest.this.settings;
            }
        };
    }

    private WorkspaceInfo add(String name) {
        WorkspaceInfo w = this.catalog.getFactory().createWorkspace();
        OwsUtils.set((Object)w, (String)"id", (Object)(name + "-id"));
        w.setName(name);
        this.catalog.add(w);
        return this.catalog.getWorkspaceByName(name);
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)4L, (long)this.provider.size());
        this.provider.setKeywords(new String[]{"w2"});
        Assert.assertEquals((long)1L, (long)this.provider.size());
    }

    @Test
    public void testFullSize() {
        Assert.assertEquals((long)4L, (long)this.provider.fullSize());
        this.provider.setKeywords(new String[]{"w2"});
        Assert.assertEquals((long)4L, (long)this.provider.fullSize());
    }

    @Test
    public void testGetProperties() {
        Assert.assertNotSame((Object)WorkspaceProvider.PROPERTIES, (Object)this.provider.getProperties());
        Assert.assertEquals((Object)WorkspaceProvider.PROPERTIES, (Object)this.provider.getProperties());
        ArrayList<GeoServerDataProvider.Property> expected = new ArrayList<GeoServerDataProvider.Property>(WorkspaceProvider.PROPERTIES);
        this.settings.setShowCreatedTimeColumnsInAdminList(true);
        expected.add(WorkspaceProvider.CREATED_TIMESTAMP);
        Assert.assertEquals(expected, (Object)this.provider.getProperties());
        this.settings.setShowModifiedTimeColumnsInAdminList(true);
        expected.add(WorkspaceProvider.MODIFIED_TIMESTAMP);
        Assert.assertEquals(expected, (Object)this.provider.getProperties());
    }

    @Test
    public void testGetItems_is_unsupported() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((WorkspaceProvider)this.provider).getItems());
    }

    @Test
    public void testIterator_preconditions() {
        Class<IllegalArgumentException> iae = IllegalArgumentException.class;
        Assert.assertThrows(iae, () -> this.provider.iterator(0x80000000L, 1L));
        Assert.assertThrows(iae, () -> this.provider.iterator(-2147483649L, 1L));
        Assert.assertThrows(iae, () -> this.provider.iterator(0L, 0x80000000L));
        Assert.assertThrows(iae, () -> this.provider.iterator(0L, -2147483649L));
    }

    @Test
    public void testIterator_all() {
        List<WorkspaceInfo> expected = List.of(this.w1, this.w2, this.w3, this.w4);
        ArrayList actual = Lists.newArrayList((Iterator)this.provider.iterator(0L, 25L));
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testIterator_orderbyName() {
        this.provider.setSort((Object)"name", SortOrder.DESCENDING);
        ArrayList actual = Lists.newArrayList((Iterator)this.provider.iterator(0L, 25L));
        Assert.assertEquals(List.of(this.w4, this.w3, this.w2, this.w1), (Object)actual);
    }

    @Test
    public void testIterator_orderbyIsolated() {
        this.w2.setIsolated(true);
        this.catalog.save(this.w2);
        this.w3.setIsolated(true);
        this.catalog.save(this.w3);
        this.provider.setSort((Object)"isolated", SortOrder.ASCENDING);
        ArrayList actual = Lists.newArrayList((Iterator)this.provider.iterator(0L, 25L));
        Assert.assertEquals(List.of(this.w1, this.w4, this.w2, this.w3), (Object)actual);
        this.provider.setSort((Object)"isolated", SortOrder.DESCENDING);
        actual = Lists.newArrayList((Iterator)this.provider.iterator(0L, 25L));
        Assert.assertEquals(List.of(this.w2, this.w3, this.w1, this.w4), (Object)actual);
    }

    @Test
    public void testIterator_orderbyDefault() {
        this.catalog.setDefaultWorkspace(this.w3);
        this.provider.setSort((Object)"default", SortOrder.ASCENDING);
        ArrayList actual = Lists.newArrayList((Iterator)this.provider.iterator(0L, 25L));
        Assert.assertEquals(List.of(this.w3, this.w1, this.w2, this.w4), (Object)actual);
        this.provider.setSort((Object)"default", SortOrder.DESCENDING);
        actual = Lists.newArrayList((Iterator)this.provider.iterator(0L, 25L));
        Assert.assertEquals(List.of(this.w1, this.w2, this.w4, this.w3), (Object)actual);
    }

    @Test
    public void testOrderByDefaultProperty() {
        this.catalog.setDefaultWorkspace(this.w3);
        this.provider.setSort((Object)"name", SortOrder.ASCENDING);
        ArrayList actual = Lists.newArrayList((Iterator)this.provider.iterator(0L, 25L));
        Assert.assertEquals((long)4L, (long)actual.size());
        WorkspaceInfo decoratedWithDefault = (WorkspaceInfo)actual.get(2);
        Assert.assertEquals((Object)this.w3.getId(), (Object)decoratedWithDefault.getId());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)WorkspaceProvider.DEFAULT.getPropertyValue((Object)decoratedWithDefault));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)WorkspaceProvider.DEFAULT.getPropertyValue((Object)((WorkspaceInfo)actual.get(0))));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)WorkspaceProvider.DEFAULT.getPropertyValue((Object)((WorkspaceInfo)actual.get(1))));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)WorkspaceProvider.DEFAULT.getPropertyValue((Object)((WorkspaceInfo)actual.get(3))));
    }
}

