/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.publish;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.feedback.ErrorLevelFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.publish.HTTPLayerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HTTPLayerConfigTest
extends GeoServerWicketTestSupport {
    LayerInfo polygons;
    FormTestPage page;

    @Before
    public void init() {
        this.polygons = this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart());
        this.page = new FormTestPage(id -> new HTTPLayerConfig(id, (IModel)new Model((Serializable)this.polygons), "resource.metadata"));
        tester.startPage((Page)this.page);
    }

    @Test
    public void testDefaults() {
        tester.assertRenderedPage(FormTestPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        Assert.assertEquals((long)0L, (long)this.page.getSession().getFeedbackMessages().messages((IFeedbackMessageFilter)new ErrorLevelFeedbackMessageFilter(400)).size());
    }

    @Test
    public void testInvalid() {
        LayerInfo polygons = this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart());
        FormTestPage page = new FormTestPage(id -> new HTTPLayerConfig(id, (IModel)new Model((Serializable)polygons), "resource.metadata"));
        tester.startPage((Page)page);
        tester.assertComponent("form:panel:cacheAgeMax", TextField.class);
        tester.assertRenderedPage(FormTestPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("panel:cacheAgeMax", "-20");
        ft.submit();
        tester.assertErrorMessages(new Serializable[]{"The value of 'cacheAgeMax' must be between 0 and 9223372036854775807."});
    }

    @Test
    public void testValid() {
        FormTester ft = tester.newFormTester("form");
        ft.setValue("panel:cacheAgeMax", "3600");
        ft.submit();
        Assert.assertEquals((long)0L, (long)this.page.getSession().getFeedbackMessages().messages((IFeedbackMessageFilter)new ErrorLevelFeedbackMessageFilter(400)).size());
        Assert.assertEquals((Object)3600, (Object)this.polygons.getResource().getMetadata().get("cacheAgeMax", Integer.class));
    }
}

