/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.geoserver.web.security.AccessDataRulePanel;
import org.geoserver.web.security.DataAccessRuleInfo;
import org.geoserver.web.security.LayerAccessDataRulePanel;
import org.geoserver.web.security.LayerAccessDataRulePanelInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LayerAccessDataRulePanelTest
extends GeoServerWicketTestSupport {
    IModel<LayerInfo> layerModel;

    @Before
    public void setUpInternal() {
        LayerInfo layerInfo = this.getCatalog().getLayerByName(this.getLayerId(MockData.BUILDINGS));
        this.layerModel = new Model((Serializable)layerInfo);
    }

    @Test
    public void testPageLoad() throws IOException {
        LayerAccessDataRulePanelInfo info = new LayerAccessDataRulePanelInfo();
        final ListModel own = info.createOwnModel(this.layerModel, false);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5907648151984337786L;

            @Override
            public Component buildComponent(String id) {
                return new LayerAccessDataRulePanel(id, LayerAccessDataRulePanelTest.this.layerModel, (IModel)own);
            }
        }));
        tester.assertComponent("form:panel", LayerAccessDataRulePanel.class);
        tester.assertComponent("form:panel:dataAccessPanel", AccessDataRulePanel.class);
        tester.assertComponent("form:panel:dataAccessPanel:listContainer", WebMarkupContainer.class);
        tester.assertComponent("form:panel:dataAccessPanel:listContainer:selectAll", CheckBox.class);
        tester.assertComponent("form:panel:dataAccessPanel:listContainer:rules", ListView.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageLoadWithExistingRules() throws IOException {
        LayerAccessDataRulePanelInfo info = new LayerAccessDataRulePanelInfo();
        AccessDataRuleInfoManager manager = new AccessDataRuleInfoManager();
        Set roles = manager.getAvailableRoles();
        String wsName = ((LayerInfo)this.layerModel.getObject()).getResource().getStore().getWorkspace().getName();
        String layerName = ((LayerInfo)this.layerModel.getObject()).getName();
        ArrayList rules = new ArrayList();
        roles.forEach(r -> {
            DataAccessRuleInfo rule = new DataAccessRuleInfo(r, layerName, wsName);
            rule.setRead(true);
            rules.add(rule);
        });
        Set newRules = manager.mapFrom(rules, roles, wsName, layerName, false);
        manager.saveRules(new HashSet(), newRules);
        try {
            final ListModel own = info.createOwnModel(this.layerModel, false);
            tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
                private static final long serialVersionUID = -5907648151984337786L;

                @Override
                public Component buildComponent(String id) {
                    return new LayerAccessDataRulePanel(id, LayerAccessDataRulePanelTest.this.layerModel, (IModel)own);
                }
            }));
            tester.assertComponent("form:panel", LayerAccessDataRulePanel.class);
            tester.assertComponent("form:panel:dataAccessPanel", AccessDataRulePanel.class);
            tester.assertComponent("form:panel:dataAccessPanel:listContainer", WebMarkupContainer.class);
            tester.assertComponent("form:panel:dataAccessPanel:listContainer:selectAll", CheckBox.class);
            tester.assertComponent("form:panel:dataAccessPanel:listContainer:rules", ListView.class);
            for (int i = 0; i < roles.size(); ++i) {
                CheckBox checkBox = (CheckBox)tester.getComponentFromLastRenderedPage("form:panel:dataAccessPanel:listContainer:rules:" + i + ":read");
                if (checkBox.getId().equals("read")) {
                    Assert.assertTrue((boolean)((Boolean)checkBox.getModelObject()));
                    continue;
                }
                Assert.assertFalse((boolean)((Boolean)checkBox.getModelObject()));
            }
        }
        finally {
            manager.saveRules(newRules, new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveRules() throws IOException {
        AccessDataRuleInfoManager manager = new AccessDataRuleInfoManager();
        String wsName = ((LayerInfo)this.layerModel.getObject()).getResource().getStore().getWorkspace().getName();
        try {
            LayerAccessDataRulePanelInfo info = new LayerAccessDataRulePanelInfo();
            final ListModel own = info.createOwnModel(this.layerModel, false);
            FormTestPage form = new FormTestPage(new ComponentBuilder(){
                private static final long serialVersionUID = -5907648151984337786L;

                @Override
                public Component buildComponent(String id) {
                    return new LayerAccessDataRulePanel(id, LayerAccessDataRulePanelTest.this.layerModel, (IModel)own);
                }
            });
            Assert.assertTrue((boolean)manager.getResourceRule(wsName, (CatalogInfo)this.layerModel.getObject()).isEmpty());
            tester.startPage((Page)form);
            tester.assertComponent("form:panel", LayerAccessDataRulePanel.class);
            ((List)own.getObject()).forEach(r -> r.setRead(true));
            LayerAccessDataRulePanel panel = (LayerAccessDataRulePanel)tester.getComponentFromLastRenderedPage("form:panel");
            panel.save();
            Assert.assertEquals((long)1L, (long)manager.getResourceRule(wsName, (CatalogInfo)this.layerModel.getObject()).size());
        }
        finally {
            manager.removeAllResourceRules(wsName, (CatalogInfo)this.layerModel.getObject());
            Assert.assertTrue((boolean)manager.getResourceRule(wsName, (CatalogInfo)this.layerModel.getObject()).isEmpty());
        }
    }
}

