/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.system.status;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.geoserver.web.system.status.ConsoleInfoUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ConsoleInfoUtilsStackTest {
    @Test
    public void testThreadsInfo() throws Exception {
        int i;
        ExecutorService es = Executors.newFixedThreadPool(1, r -> new Thread(r, "myTestThread"));
        CountDownLatch latch = new CountDownLatch(2);
        es.submit(() -> ConsoleInfoUtilsStackTest.method1(latch));
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(latch::getCount, CoreMatchers.is((Object)1L));
        String info = ConsoleInfoUtils.getThreadsInfo((boolean)true, (boolean)true);
        latch.countDown();
        es.shutdown();
        AtomicBoolean inBlock = new AtomicBoolean(false);
        Predicate<String> traceFinder = l -> {
            if (!inBlock.get()) {
                if (l.startsWith("\"myTestThread\"")) {
                    inBlock.set(true);
                }
            } else if (l.trim().isEmpty()) {
                inBlock.set(false);
            }
            return inBlock.get();
        };
        List testStack = info.lines().filter(traceFinder).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)testStack.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(11)));
        MatcherAssert.assertThat((Object)((String)testStack.get(0)), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"myTestThread"), (Matcher)Matchers.containsString((String)"WAITING")));
        int idxFirst = -1;
        for (i = 0; i < testStack.size(); ++i) {
            if (!((String)testStack.get(i)).contains("method1(")) continue;
            idxFirst = i;
            break;
        }
        Assert.assertNotEquals((long)-1L, (long)idxFirst);
        for (i = 1; i <= 10; ++i) {
            MatcherAssert.assertThat((Object)((String)testStack.get(idxFirst + 1 - i)), (Matcher)Matchers.containsString((String)("at org.geoserver.web.system.status.ConsoleInfoUtilsStackTest.method" + i)));
        }
    }

    private static void method1(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method2(latch);
    }

    private static void method2(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method3(latch);
    }

    private static void method3(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method4(latch);
    }

    private static void method4(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method5(latch);
    }

    private static void method5(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method6(latch);
    }

    private static void method6(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method7(latch);
    }

    private static void method7(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method8(latch);
    }

    private static void method8(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method9(latch);
    }

    private static void method9(CountDownLatch latch) {
        ConsoleInfoUtilsStackTest.method10(latch);
    }

    private static void method10(CountDownLatch latch) {
        latch.countDown();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

