/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.CRSPanelTestPage;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;

public class CRSPanelTest
extends GeoServerWicketTestSupport {
    @Test
    public void testStandloneUnset() throws Exception {
        tester.startPage((Page)new CRSPanelTestPage());
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:crs", CRSPanel.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        CRSPanel crsPanel = (CRSPanel)tester.getComponentFromLastRenderedPage("form:crs");
        Assert.assertNull((Object)crsPanel.getCRS());
    }

    @Test
    public void testStandaloneUnchanged() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        tester.startPage((Page)new CRSPanelTestPage((CoordinateReferenceSystem)crs));
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:crs", CRSPanel.class);
        FormTester ft = tester.newFormTester("form", false);
        ft.submit();
        CRSPanel crsPanel = (CRSPanel)tester.getComponentFromLastRenderedPage("form:crs");
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crsPanel.getCRS()));
    }

    @Test
    public void testPopupWindow() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        tester.startPage((Page)new CRSPanelTestPage((CoordinateReferenceSystem)crs));
        GSModalWindow window = (GSModalWindow)tester.getComponentFromLastRenderedPage("form:crs:popup");
        Assert.assertFalse((boolean)window.isShown());
        tester.clickLink("form:crs:wkt", true);
        Assert.assertTrue((boolean)window.isShown());
        tester.assertModelValue("form:crs:popup:modal:overlay:dialog:content:content:wkt", (Object)crs.toWKT());
    }

    @Test
    public void testPopupWindowNoCRS() throws Exception {
        tester.startPage((Page)new CRSPanelTestPage());
        GSModalWindow window = (GSModalWindow)tester.getComponentFromLastRenderedPage("form:crs:popup");
        Assert.assertFalse((boolean)window.isShown());
        GeoServerAjaxFormLink link = (GeoServerAjaxFormLink)tester.getComponentFromLastRenderedPage("form:crs:wkt");
        Assert.assertFalse((boolean)link.isEnabled());
    }

    @Test
    public void testStandaloneChanged() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        tester.startPage((Page)new CRSPanelTestPage((CoordinateReferenceSystem)crs));
        TextField srs = (TextField)tester.getComponentFromLastRenderedPage("form:crs:srs");
        srs.setModelObject((Object)"EPSG:3005");
        FormTester ft = tester.newFormTester("form", false);
        ft.submit();
        CRSPanel crsPanel = (CRSPanel)tester.getComponentFromLastRenderedPage("form:crs");
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:3005"), (Object)crsPanel.getCRS()));
    }

    @Test
    public void testStandaloneChanged2() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        tester.startPage((Page)new CRSPanelTestPage((CoordinateReferenceSystem)crs));
        FormTester ft = tester.newFormTester("form");
        ft.setValue("crs:srs", "EPSG:3005");
        ft.submit();
        tester.assertNoErrorMessage();
        CRSPanel crsPanel = (CRSPanel)tester.getComponentFromLastRenderedPage("form:crs");
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:3005"), (Object)crsPanel.getCRS()));
    }

    @Test
    public void testRequired() throws Exception {
        tester.startPage((Page)new CRSPanelTestPage((CoordinateReferenceSystem)null));
        CRSPanel panel = (CRSPanel)tester.getComponentFromLastRenderedPage("form:crs");
        panel.setRequired(true);
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        Assert.assertEquals((long)1L, (long)panel.getFeedbackMessages().size());
    }

    @Test
    public void testCompoundPropertyUnchanged() throws Exception {
        Foo foo = new Foo((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tester.startPage((Page)new CRSPanelTestPage(foo));
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:crs", CRSPanel.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)foo.crs);
    }

    @Test
    public void testCompoundPropertyChanged() throws Exception {
        Foo foo = new Foo((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tester.startPage((Page)new CRSPanelTestPage(foo));
        TextField srs = (TextField)tester.getComponentFromLastRenderedPage("form:crs:srs");
        srs.setModelObject((Object)"EPSG:3005");
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:3005"), (Object)foo.crs);
    }

    @Test
    public void testPropertyUnchanged() throws Exception {
        Foo foo = new Foo((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tester.startPage((Page)new CRSPanelTestPage((IModel<CoordinateReferenceSystem>)new PropertyModel((Object)foo, "crs")));
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:crs", CRSPanel.class);
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)foo.crs);
    }

    @Test
    public void testPropertyChanged() throws Exception {
        Foo foo = new Foo((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tester.startPage((Page)new CRSPanelTestPage((IModel<CoordinateReferenceSystem>)new PropertyModel((Object)foo, "crs")));
        TextField srs = (TextField)tester.getComponentFromLastRenderedPage("form:crs:srs");
        srs.setModelObject((Object)"EPSG:3005");
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:3005"), (Object)foo.crs);
    }

    @Test
    public void testAutoCode() throws Exception {
        String AUTO = "AUTO:42003,9001,-20,-45";
        tester.startPage((Page)new CRSPanelTestPage("AUTO:42003,9001,-20,-45"));
        FormTester ft = tester.newFormTester("form");
        ft.setValue("crs:srs", "AUTO:42003,9001,-20,-45");
        ft.submit();
        tester.assertNoErrorMessage();
        CRSPanel crsPanel = (CRSPanel)tester.getComponentFromLastRenderedPage("form:crs");
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"AUTO:42003,9001,-20,-45"), (Object)crsPanel.getCRS()));
    }

    @Test
    public void testPlanetary() throws Exception {
        String sun = "IAU:1000";
        tester.startPage((Page)new CRSPanelTestPage("IAU:1000"));
        FormTester ft = tester.newFormTester("form");
        ft.setValue("crs:srs", "IAU:1000");
        ft.submit();
        tester.assertNoErrorMessage();
        CRSPanel crsPanel = (CRSPanel)tester.getComponentFromLastRenderedPage("form:crs");
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"IAU:1000"), (Object)crsPanel.getCRS()));
    }

    @Test
    public void testPlanetaryPopupWindow() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"IAU:30100");
        tester.startPage((Page)new CRSPanelTestPage(crs));
        GSModalWindow window = (GSModalWindow)tester.getComponentFromLastRenderedPage("form:crs:popup");
        Assert.assertFalse((boolean)window.isShown());
        tester.clickLink("form:crs:wkt", true);
        Assert.assertTrue((boolean)window.isShown());
        tester.assertModelValue("form:crs:popup:modal:overlay:dialog:content:content:wkt", (Object)crs.toWKT());
    }

    @Test
    public void testPlanetaryList() throws Exception {
        CoordinateReferenceSystem crs = CRS.decode((String)"IAU:30100");
        tester.startPage((Page)new CRSPanelTestPage(crs));
        GSModalWindow window = (GSModalWindow)tester.getComponentFromLastRenderedPage("form:crs:popup");
        Assert.assertFalse((boolean)window.isShown());
        tester.clickLink("form:crs:find", true);
        Assert.assertTrue((boolean)window.isShown());
        FormTester ft = tester.newFormTester("form");
        ft.setValue("crs:popup:modal:overlay:dialog:content:content:table:filterForm:filter", "IAU:30115");
        ft.submit("crs:popup:modal:overlay:dialog:content:content:table:filterForm:submit");
        tester.getLastRenderedPage().visitChildren(AjaxLink.class, (link, visit) -> {
            if ("IAU:30115".equals(link.getDefaultModelObjectAsString())) {
                visit.stop();
                tester.executeAjaxEvent(link, "click");
            }
        });
        Assert.assertFalse((boolean)window.isShown());
        tester.assertModelValue("form:crs:srs", (Object)"IAU:30115");
        this.print((Component)tester.getLastRenderedPage(), true, true, true);
    }

    static class Foo
    implements Serializable {
        public CoordinateReferenceSystem crs;

        Foo(CoordinateReferenceSystem crs) {
            this.crs = crs;
        }
    }
}

