/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.DecimalListTextField;
import org.geoserver.web.wicket.InputTestPage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DecimalListTextFieldTest {
    WicketTester tester;
    List<Double> theList = new ArrayList<Double>();
    static Locale originalLocale;

    @BeforeClass
    public static void setLocale() {
        originalLocale = Locale.getDefault();
        Locale.setDefault(Locale.ITALIAN);
    }

    @AfterClass
    public static void resetLocale() {
        Locale.setDefault(originalLocale);
    }

    @Before
    public void setUp() throws Exception {
        this.tester = new WicketTester();
        GeoServerWicketTestSupport.initResourceSettings(this.tester);
        this.tester.startPage((Page)new InputTestPage(){

            @Override
            protected Component newTextInput(String id) {
                return new DecimalListTextField(id, (IModel)new PropertyModel((Object)DecimalListTextFieldTest.this, "theList"));
            }
        });
    }

    @Test
    public void testEmpty() throws Exception {
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("input", "      ");
        ft.submit();
        Assert.assertEquals((long)0L, (long)this.theList.size());
    }

    @Test
    public void testLocale() throws Exception {
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("input", "1,3 12,15");
        ft.submit();
        Assert.assertEquals((long)2L, (long)this.theList.size());
        Assert.assertEquals((double)1.3, (double)this.theList.get(0), (double)0.0);
        Assert.assertEquals((double)12.15, (double)this.theList.get(1), (double)0.0);
    }

    @Test
    public void testScientific() throws Exception {
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("input", "1E-3 1E5");
        ft.submit();
        Assert.assertEquals((long)2L, (long)this.theList.size());
        Assert.assertEquals((double)0.001, (double)this.theList.get(0), (double)0.0);
        Assert.assertEquals((double)100000.0, (double)this.theList.get(1), (double)0.0);
    }
}

