/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.DecimalTextField;
import org.geoserver.web.wicket.InputTestPage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DecimalTextFieldTest {
    WicketTester tester;
    Double theValue;
    static Locale originalLocale;

    @BeforeClass
    public static void setLocale() {
        originalLocale = Locale.getDefault();
        Locale.setDefault(Locale.ITALIAN);
    }

    @AfterClass
    public static void resetLocale() {
        Locale.setDefault(originalLocale);
    }

    @Before
    public void setUp() throws Exception {
        this.tester = new WicketTester();
        GeoServerWicketTestSupport.initResourceSettings(this.tester);
        this.tester.startPage((Page)new InputTestPage(){

            @Override
            protected Component newTextInput(String id) {
                return new DecimalTextField(id, (IModel)new PropertyModel((Object)DecimalTextFieldTest.this, "theValue"));
            }
        });
    }

    @Test
    public void testEmpty() throws Exception {
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("input", "");
        ft.submit();
        Assert.assertNull((Object)this.theValue);
    }

    @Test
    public void testNaN() throws Exception {
        this.theValue = Double.NaN;
        this.setUp();
        FormTester ft = this.tester.newFormTester("form");
        ft.submit();
        Assert.assertEquals((Object)Double.NaN, (Object)this.theValue);
    }

    @Test
    public void testLocale() throws Exception {
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("input", "12,15");
        ft.submit();
        Assert.assertEquals((double)12.15, (double)this.theValue, (double)0.0);
    }

    @Test
    public void testScientific() throws Exception {
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("input", "1E5");
        ft.submit();
        Assert.assertEquals((double)100000.0, (double)this.theValue, (double)0.0);
    }
}

