/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geotools.api.referencing.FactoryException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;

public class EnvelopePanelBoundingBoxTest
extends GeoServerWicketTestSupport {
    private static final String FORM = "form";

    @Test
    public void testInvalidBoundingBoxValuesEqual() throws FactoryException {
        ReferencedEnvelope3D e = new ReferencedEnvelope3D(180.0, 180.0, 90.0, 90.0, 20.0, 20.0, CRS.decode((String)"EPSG:7415"));
        tester.startPage((Page)new FormTestPage(arg_0 -> this.lambda$testInvalidBoundingBoxValuesEqual$fed6260b$1((ReferencedEnvelope)e, arg_0)));
        tester.assertComponent(FORM, Form.class);
        FormTester ft = tester.newFormTester(FORM);
        ft.submit();
        Assert.assertEquals((long)3L, (long)tester.getFeedbackMessages(null).size());
    }

    @Test
    public void testInvalidBoundingBoxValuesLower() throws FactoryException {
        ReferencedEnvelope3D e = new ReferencedEnvelope3D(180.0, 180.0, 90.0, 90.0, 20.0, 20.0, CRS.decode((String)"EPSG:7415"));
        tester.startPage((Page)new FormTestPage(arg_0 -> this.lambda$testInvalidBoundingBoxValuesLower$fed6260b$1((ReferencedEnvelope)e, arg_0)));
        tester.assertComponent(FORM, Form.class);
        FormTester ft = tester.newFormTester(FORM);
        ft.setValue("panel:minX", "181");
        ft.setValue("panel:minY", "91");
        ft.setValue("panel:minZ", "21");
        ft.submit();
        Assert.assertEquals((long)3L, (long)tester.getFeedbackMessages(null).size());
    }

    @Test
    public void testValidBoundingBoxValues() throws FactoryException {
        ReferencedEnvelope3D e = new ReferencedEnvelope3D(180.0, 181.0, 90.0, 91.0, 20.0, 21.0, CRS.decode((String)"EPSG:7415"));
        tester.startPage((Page)new FormTestPage(arg_0 -> this.lambda$testValidBoundingBoxValues$fed6260b$1((ReferencedEnvelope)e, arg_0)));
        tester.assertComponent(FORM, Form.class);
        FormTester ft = tester.newFormTester(FORM);
        ft.submit();
        Assert.assertEquals((long)0L, (long)tester.getFeedbackMessages(null).size());
    }

    private Component providePanel(ReferencedEnvelope e, String id) {
        EnvelopePanel panel = new EnvelopePanel(id, e);
        panel.setCRSFieldVisible(true);
        return panel;
    }

    private /* synthetic */ Component lambda$testValidBoundingBoxValues$fed6260b$1(ReferencedEnvelope e, String id) {
        return this.providePanel(e, id);
    }

    private /* synthetic */ Component lambda$testInvalidBoundingBoxValuesLower$fed6260b$1(ReferencedEnvelope e, String id) {
        return this.providePanel(e, id);
    }

    private /* synthetic */ Component lambda$testInvalidBoundingBoxValuesEqual$fed6260b$1(ReferencedEnvelope e, String id) {
        return this.providePanel(e, id);
    }
}

