/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.wicket.validation.IValidatable;
import org.geoserver.web.StringValidatable;
import org.geoserver.web.wicket.FileExistsValidator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileExistsValidatorTest {
    private static File root;
    private static FileExistsValidator validator;

    @BeforeClass
    public static void init() throws IOException {
        root = File.createTempFile("file", "tmp", new File("target"));
        root.delete();
        root.mkdirs();
        File wcs = new File(root, "wcs");
        wcs.mkdir();
        Files.touch((File)new File(wcs, "BlueMarble.tiff"));
        validator = new FileExistsValidator();
        FileExistsValidatorTest.validator.baseDirectory = root;
    }

    @Test
    public void testAbsoluteRaw() throws Exception {
        File tazbm = new File(root, "wcs/BlueMarble.tiff");
        StringValidatable validatable = new StringValidatable(tazbm.getAbsolutePath());
        validator.validate((IValidatable)validatable);
        Assert.assertTrue((boolean)validatable.isValid());
    }

    @Test
    public void testAbsoluteURI() throws Exception {
        File tazbm = new File(root, "wcs/BlueMarble.tiff");
        StringValidatable validatable = new StringValidatable(tazbm.toURI().toString());
        validator.validate((IValidatable)validatable);
        Assert.assertTrue((boolean)validatable.isValid());
    }

    @Test
    public void testRelative() throws Exception {
        StringValidatable validatable = new StringValidatable("file:wcs/BlueMarble.tiff");
        validator.validate((IValidatable)validatable);
        Assert.assertTrue((boolean)validatable.isValid());
    }
}

