/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.Iterator;
import java.util.List;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.ows.wms.Layer;
import org.junit.Assert;
import org.junit.Test;

public class GeoServerDataProviderTest {
    private final GeoServerDataProvider<Layer> geoServerLayerDataProviderMock = new GeoServerDataProvider<Layer>(){

        protected List<GeoServerDataProvider.Property<Layer>> getProperties() {
            return List.of(new GeoServerDataProvider.BeanProperty("title", "title"));
        }

        protected List<Layer> getItems() {
            return List.of(new Layer("key"), new Layer("keyword"));
        }
    };

    @Test
    public void fullTextFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"keyword"});
        Filter filter = this.geoServerLayerDataProviderMock.getFilter();
        Assert.assertEquals((Object)"AnyText ILIKE '*keyword*'", (Object)ECQL.toCQL((Filter)filter));
    }

    @Test
    public void exactTermFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"'keyword'"});
        Filter filter = this.geoServerLayerDataProviderMock.getFilter();
        Assert.assertEquals((Object)"AnyText ILIKE 'keyword'", (Object)ECQL.toCQL((Filter)filter));
    }

    @Test
    public void mixedFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"keyword", "'keyword'"});
        Filter filter = this.geoServerLayerDataProviderMock.getFilter();
        Assert.assertEquals((Object)"AnyText ILIKE '*keyword*' OR AnyText ILIKE 'keyword'", (Object)ECQL.toCQL((Filter)filter));
    }

    @Test
    public void emptyFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(null);
        Filter filter = this.geoServerLayerDataProviderMock.getFilter();
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)filter);
    }

    @Test
    public void mismatchedQuotedExactTermFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"\"keyword'", "'keyword"});
        Filter filter = this.geoServerLayerDataProviderMock.getFilter();
        Assert.assertEquals((Object)"AnyText ILIKE '*\"keyword'*' OR AnyText ILIKE '*'keyword*'", (Object)ECQL.toCQL((Filter)filter));
    }

    @Test
    public void emptyQuotedExactTermFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"\"\""});
        Filter filter = this.geoServerLayerDataProviderMock.getFilter();
        Assert.assertEquals((Object)"AnyText ILIKE '*\"\"*'", (Object)ECQL.toCQL((Filter)filter));
    }

    @Test
    public void fullTextRegexFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"key"});
        Iterator iterator = this.geoServerLayerDataProviderMock.iterator(0L, Long.MAX_VALUE);
        Assert.assertEquals((Object)"key", (Object)((Layer)iterator.next()).getTitle());
        Assert.assertEquals((Object)"keyword", (Object)((Layer)iterator.next()).getTitle());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void exactTermRegexFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"'key'"});
        Iterator iterator = this.geoServerLayerDataProviderMock.iterator(0L, Long.MAX_VALUE);
        Assert.assertEquals((Object)"key", (Object)((Layer)iterator.next()).getTitle());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void mixedRegexFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"key", "'key'"});
        Iterator iterator = this.geoServerLayerDataProviderMock.iterator(0L, Long.MAX_VALUE);
        Assert.assertEquals((Object)"key", (Object)((Layer)iterator.next()).getTitle());
        Assert.assertEquals((Object)"keyword", (Object)((Layer)iterator.next()).getTitle());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void emptyRegexFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[0]);
        Iterator iterator = this.geoServerLayerDataProviderMock.iterator(0L, Long.MAX_VALUE);
        Assert.assertEquals((Object)"key", (Object)((Layer)iterator.next()).getTitle());
        Assert.assertEquals((Object)"keyword", (Object)((Layer)iterator.next()).getTitle());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void mismatchedQuotedExactTermRegexFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"\"keyword'", "'keyword"});
        Iterator iterator = this.geoServerLayerDataProviderMock.iterator(0L, Long.MAX_VALUE);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void emptyQuotedExactTermRegexFilter() {
        this.geoServerLayerDataProviderMock.setKeywords(new String[]{"\"\""});
        Iterator iterator = this.geoServerLayerDataProviderMock.iterator(0L, Long.MAX_VALUE);
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

