/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.wicket.WKTToCRSModel;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;

public class WKTToCRSModelTest {
    @Test
    public void testNullSRS() throws Exception {
        Model wkt = new Model(null);
        WKTToCRSModel crs = new WKTToCRSModel((IModel)wkt);
        Assert.assertNull((Object)crs.getObject());
        crs.setObject(null);
        Assert.assertNull((Object)wkt.getObject());
    }

    @Test
    public void testNonNullSRS() throws Exception {
        CoordinateReferenceSystem utm32n = CRS.decode((String)"EPSG:32632");
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
        Model wkt = new Model((Serializable)((Object)utm32n.toString()));
        WKTToCRSModel crs = new WKTToCRSModel((IModel)wkt);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)utm32n, (Object)crs.getObject()));
        crs.setObject(wgs84);
        Assert.assertEquals((Object)wgs84.toString(), (Object)wkt.getObject());
    }
}

