/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.wicket.browser.FileBreadcrumbs;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileBreadcrumsTest {
    private WicketTester tester;
    private File root;
    private File leaf;
    private File lastClicked;

    @Before
    public void setUp() throws Exception {
        this.tester = new WicketTester();
        this.root = new File("target/test-breadcrumbs");
        this.leaf = new File("target/test-breadcrumbs/one/two/three");
        if (!this.leaf.exists()) {
            this.leaf.mkdirs();
        }
        this.tester.startPage((Page)new FormTestPage(id -> new FileBreadcrumbs(id, (IModel)new Model((Serializable)this.root), (IModel)new Model((Serializable)this.leaf)){

            protected void pathItemClicked(File file, Optional<AjaxRequestTarget> target) {
                FileBreadcrumsTest.this.lastClicked = file;
                this.setSelection(file);
            }
        }));
    }

    @Test
    public void testLoad() throws Exception {
        this.tester.assertRenderedPage(FormTestPage.class);
        this.tester.assertNoErrorMessage();
        this.tester.assertLabel("form:panel:path:0:pathItemLink:pathItem", "test-breadcrumbs/");
        this.tester.assertLabel("form:panel:path:1:pathItemLink:pathItem", "one/");
        this.tester.assertLabel("form:panel:path:2:pathItemLink:pathItem", "two/");
        this.tester.assertLabel("form:panel:path:3:pathItemLink:pathItem", "three/");
    }

    @Test
    public void testFollowLink() throws Exception {
        this.tester.clickLink("form:panel:path:1:pathItemLink");
        this.tester.assertRenderedPage(FormTestPage.class);
        this.tester.assertNoErrorMessage();
        Assert.assertEquals((Object)new File("target/test-breadcrumbs/one"), (Object)this.lastClicked);
        this.tester.assertLabel("form:panel:path:0:pathItemLink:pathItem", "test-breadcrumbs/");
        this.tester.assertLabel("form:panel:path:1:pathItemLink:pathItem", "one/");
        Assert.assertEquals((long)2L, (long)((ListView)this.tester.getComponentFromLastRenderedPage("form:panel:path")).getList().size());
    }
}

